rule win_feed_load_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.feed_load."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.feed_load"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 4863563c 4533c9 4803d6 0fb74a14 4c8d4218 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   4863563c             | mov                 eax, dword ptr [esp + 0x38]
            //   4533c9               | inc                 ebp
            //   4803d6               | sub                 ebp, esp
            //   0fb74a14             | dec                 eax
            //   4c8d4218             | mov                 dword ptr [esp + 0x38], edx

        $sequence_1 = { 7503 4803dd 8bcb 412bcd 8bc1 4983c704 }
            // n = 6, score = 100
            //   7503                 | dec                 eax
            //   4803dd               | mov                 ebx, ecx
            //   8bcb                 | dec                 eax
            //   412bcd               | mov                 dword ptr [ecx], eax
            //   8bc1                 | test                dl, 1
            //   4983c704             | inc                 eax

        $sequence_2 = { 33f6 215828 33ff 4533e4 e8???????? 85c0 0f844f010000 }
            // n = 7, score = 100
            //   33f6                 | xor                 esi, esi
            //   215828               | dec                 eax
            //   33ff                 | mov                 edi, ecx
            //   4533e4               | xor                 edx, edx
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   0f844f010000         | sub                 esp, 0x60

        $sequence_3 = { e8???????? 4983ceff 33db 4c8d256cbf0100 895c2420 81fb80000000 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   4983ceff             | mov                 ecx, dword ptr [edi + 8]
            //   33db                 | dec                 eax
            //   4c8d256cbf0100       | mov                 dword ptr [esp + 0x38], esi
            //   895c2420             | mov                 dword ptr [esp + 0x30], esi
            //   81fb80000000         | mov                 dword ptr [esp + 0x28], 3

        $sequence_4 = { e8???????? 33db 8bf8 85c0 0f8453020000 4c8d2dc25b0100 448bf3 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   33db                 | add                 eax, 0xffff
            //   8bf8                 | cmp                 eax, ecx
            //   85c0                 | jb                  0x83
            //   0f8453020000         | inc                 ecx
            //   4c8d2dc25b0100       | mov                 eax, dword ptr [esp]
            //   448bf3               | cmp                 dword ptr [ebx], eax

        $sequence_5 = { 7c29 418bc1 488bcf 41f7e5 c1ea07 }
            // n = 5, score = 100
            //   7c29                 | inc                 ebp
            //   418bc1               | xor                 eax, eax
            //   488bcf               | inc                 ebp
            //   41f7e5               | test                ecx, ecx
            //   c1ea07               | je                  0x11bc

        $sequence_6 = { 488bc8 ff15???????? 488b4c2428 488d155e2f0300 448b1d???????? 4803c9 }
            // n = 6, score = 100
            //   488bc8               | mov                 dword ptr [ebp - 0x31], eax
            //   ff15????????         |                     
            //   488b4c2428           | dec                 eax
            //   488d155e2f0300       | mov                 esi, ecx
            //   448b1d????????       |                     
            //   4803c9               | dec                 eax

        $sequence_7 = { 6683f802 0f852f010000 bb280a0000 448bc3 33d2 488d4c2460 e8???????? }
            // n = 7, score = 100
            //   6683f802             | mov                 edx, dword ptr [esp + 0x80]
            //   0f852f010000         | inc                 esp
            //   bb280a0000           | lea                 eax, [edi + 0x18]
            //   448bc3               | inc                 esp
            //   33d2                 | mov                 dword ptr [edx], eax
            //   488d4c2460           | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { 488d159d650200 488bcb 488905???????? ff15???????? 488d159e650200 488bcb 488905???????? }
            // n = 7, score = 100
            //   488d159d650200       | dec                 esp
            //   488bcb               | mov                 ecx, edi
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488d159e650200       | mov                 edx, ebx
            //   488bcb               | dec                 eax
            //   488905????????       |                     

        $sequence_9 = { 488d45e0 4533c9 4889442428 33d2 448975e0 48897c2420 458d4101 }
            // n = 7, score = 100
            //   488d45e0             | test                eax, eax
            //   4533c9               | je                  0x17ba
            //   4889442428           | dec                 esp
            //   33d2                 | lea                 eax, [0x21382]
            //   448975e0             | inc                 ebp
            //   48897c2420           | mov                 ecx, esp
            //   458d4101             | dec                 eax

    condition:
        7 of them and filesize < 512000
}