rule win_feodo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.feodo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.feodo"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c120 8d51d0 83fa09 7704 8bca eb10 8d519f }
            // n = 7, score = 1100
            //   83c120               | add                 ecx, 0x20
            //   8d51d0               | lea                 edx, [ecx - 0x30]
            //   83fa09               | cmp                 edx, 9
            //   7704                 | ja                  6
            //   8bca                 | mov                 ecx, edx
            //   eb10                 | jmp                 0x12
            //   8d519f               | lea                 edx, [ecx - 0x61]

        $sequence_1 = { 6a00 8d4c240c 51 52 50 8b442414 50 }
            // n = 7, score = 1100
            //   6a00                 | push                0
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   50                   | push                eax
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   50                   | push                eax

        $sequence_2 = { 6a00 8d542424 52 6a00 ff15???????? 85c0 }
            // n = 6, score = 1100
            //   6a00                 | push                0
            //   8d542424             | lea                 edx, [esp + 0x24]
            //   52                   | push                edx
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_3 = { 83c8ff c3 8b4c2404 b802000000 50 8b44240c }
            // n = 6, score = 1100
            //   83c8ff               | or                  eax, 0xffffffff
            //   c3                   | ret                 
            //   8b4c2404             | mov                 ecx, dword ptr [esp + 4]
            //   b802000000           | mov                 eax, 2
            //   50                   | push                eax
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]

        $sequence_4 = { 742f 8b0f 6a01 68???????? 68???????? 68???????? }
            // n = 6, score = 1100
            //   742f                 | je                  0x31
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   6a01                 | push                1
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     

        $sequence_5 = { 6a00 8d942418020000 52 50 }
            // n = 4, score = 1100
            //   6a00                 | push                0
            //   8d942418020000       | lea                 edx, [esp + 0x218]
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_6 = { 68???????? 6a00 50 ff15???????? 8b0e }
            // n = 5, score = 1100
            //   68????????           |                     
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b0e                 | mov                 ecx, dword ptr [esi]

        $sequence_7 = { 50 8b442414 50 ff15???????? 85c0 7405 }
            // n = 6, score = 1100
            //   50                   | push                eax
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7

        $sequence_8 = { 2453 150d14f452 696969697f3cc3 af e2c3 }
            // n = 5, score = 100
            //   2453                 | and                 al, 0x53
            //   150d14f452           | adc                 eax, 0x52f4140d
            //   696969697f3cc3       | imul                ebp, dword ptr [ecx + 0x69], 0xc33c7f69
            //   af                   | scasd               eax, dword ptr es:[edi]
            //   e2c3                 | loop                0xffffffc5

        $sequence_9 = { 1487 041e 6e 18b8161e6e18 }
            // n = 4, score = 100
            //   1487                 | adc                 al, 0x87
            //   041e                 | add                 al, 0x1e
            //   6e                   | outsb               dx, byte ptr [esi]
            //   18b8161e6e18         | sbb                 byte ptr [eax + 0x186e1e16], bh

        $sequence_10 = { e2c3 e450 2478 232e }
            // n = 4, score = 100
            //   e2c3                 | loop                0xffffffc5
            //   e450                 | in                  al, 0x50
            //   2478                 | and                 al, 0x78
            //   232e                 | and                 ebp, dword ptr [esi]

        $sequence_11 = { 7e67 08ee 73fe 6c 3800 16 }
            // n = 6, score = 100
            //   7e67                 | jle                 0x69
            //   08ee                 | or                  dh, ch
            //   73fe                 | jae                 0
            //   6c                   | insb                byte ptr es:[edi], dx
            //   3800                 | cmp                 byte ptr [eax], al
            //   16                   | push                ss

        $sequence_12 = { 2478 232e 1c5f 8d422e 2e2e2e2e2ee02e 2e2e2e2e2e2e2ea12e2e2e2e 690b721cb889 }
            // n = 7, score = 100
            //   2478                 | and                 al, 0x78
            //   232e                 | and                 ebp, dword ptr [esi]
            //   1c5f                 | sbb                 al, 0x5f
            //   8d422e               | lea                 eax, [edx + 0x2e]
            //   2e2e2e2e2ee02e       | loopne              0x35
            //   2e2e2e2e2e2e2ea12e2e2e2e     | mov    eax, dword ptr cs:[0x2e2e2e2e]
            //   690b721cb889         | imul                ecx, dword ptr [ebx], 0x89b81c72

        $sequence_13 = { 0056b0 2e2801 0bd0 83c4ce 00576a }
            // n = 5, score = 100
            //   0056b0               | add                 byte ptr [esi - 0x50], dl
            //   2e2801               | sub                 byte ptr cs:[ecx], al
            //   0bd0                 | or                  edx, eax
            //   83c4ce               | add                 esp, -0x32
            //   00576a               | add                 byte ptr [edi + 0x6a], dl

        $sequence_14 = { 9a519a519a2e2e 2e2e20640444 4c 4c 63ab08080808 08c9 }
            // n = 6, score = 100
            //   9a519a519a2e2e       | lcall               0x2e2e:0x9a519a51
            //   2e2e20640444         | and                 byte ptr cs:[esp + eax + 0x44], ah
            //   4c                   | dec                 esp
            //   4c                   | dec                 esp
            //   63ab08080808         | arpl                word ptr [ebx + 0x8080808], bp
            //   08c9                 | or                  cl, cl

        $sequence_15 = { 2ee83e207468 60 238b0d03c783 782e 1463 ab }
            // n = 6, score = 100
            //   2ee83e207468         | call                0x68742044
            //   60                   | pushal              
            //   238b0d03c783         | and                 ecx, dword ptr [ebx - 0x7c38fcf3]
            //   782e                 | js                  0x30
            //   1463                 | adc                 al, 0x63
            //   ab                   | stosd               dword ptr es:[edi], eax

    condition:
        7 of them and filesize < 270336
}