rule win_forest_tiger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.forest_tiger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.forest_tiger"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 833f01 0f94c0 84c0 7407 e8???????? }
            // n = 5, score = 200
            //   833f01               | cmp                 dword ptr [edi], 1
            //   0f94c0               | sete                al
            //   84c0                 | test                al, al
            //   7407                 | je                  9
            //   e8????????           |                     

        $sequence_1 = { 6bc930 8975e0 8db1c0084400 8975e4 }
            // n = 4, score = 100
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8db1c0084400         | lea                 esi, [ecx + 0x4408c0]
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi

        $sequence_2 = { 6aff 8d8df4fdffff 51 52 }
            // n = 4, score = 100
            //   6aff                 | push                -1
            //   8d8df4fdffff         | lea                 ecx, [ebp - 0x20c]
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_3 = { 4c2be6 8bc3 c1e810 41880424 }
            // n = 4, score = 100
            //   4c2be6               | dec                 edx
            //   8bc3                 | lea                 edi, [edi - 1]
            //   c1e810               | dec                 esp
            //   41880424             | lea                 esp, [esi + 1]

        $sequence_4 = { 4c2be6 8bc3 c1e808 41880424 4c2be6 8bc3 }
            // n = 6, score = 100
            //   4c2be6               | inc                 ebp
            //   8bc3                 | mov                 byte ptr [esp], bh
            //   c1e808               | dec                 esp
            //   41880424             | sub                 esp, esi
            //   4c2be6               | inc                 ecx
            //   8bc3                 | mov                 eax, edi

        $sequence_5 = { 6aff 8d942498010000 6880000000 52 }
            // n = 4, score = 100
            //   6aff                 | push                -1
            //   8d942498010000       | lea                 edx, [esp + 0x198]
            //   6880000000           | push                0x80
            //   52                   | push                edx

        $sequence_6 = { 6aff ff15???????? 894604 85c0 7429 }
            // n = 5, score = 100
            //   6aff                 | push                -1
            //   ff15????????         |                     
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   85c0                 | test                eax, eax
            //   7429                 | je                  0x2b

        $sequence_7 = { 6bc009 0fb68408c0724300 6a08 c1e804 }
            // n = 4, score = 100
            //   6bc009               | imul                eax, eax, 9
            //   0fb68408c0724300     | movzx               eax, byte ptr [eax + ecx + 0x4372c0]
            //   6a08                 | push                8
            //   c1e804               | shr                 eax, 4

        $sequence_8 = { 4c2be6 4a8d7c27ff 4c8d6601 4c8bc7 }
            // n = 4, score = 100
            //   4c2be6               | dec                 esp
            //   4a8d7c27ff           | sub                 esp, esi
            //   4c8d6601             | inc                 ebp
            //   4c8bc7               | mov                 byte ptr [esp], bh

        $sequence_9 = { 4c2be6 418bc7 c1e808 41880424 4c2be6 418bc7 c1e810 }
            // n = 7, score = 100
            //   4c2be6               | dec                 esp
            //   418bc7               | sub                 esp, esi
            //   c1e808               | inc                 ecx
            //   41880424             | mov                 eax, edi
            //   4c2be6               | shr                 eax, 8
            //   418bc7               | inc                 ecx
            //   c1e810               | mov                 byte ptr [esp], al

        $sequence_10 = { 4c2be6 c1eb18 41881c24 4c2be6 }
            // n = 4, score = 100
            //   4c2be6               | mov                 eax, edi
            //   c1eb18               | mov                 edx, 0x20
            //   41881c24             | dec                 ecx
            //   4c2be6               | mov                 ecx, esp

        $sequence_11 = { 6bc00c 56 ff90f0664300 59 }
            // n = 4, score = 100
            //   6bc00c               | imul                eax, eax, 0xc
            //   56                   | push                esi
            //   ff90f0664300         | call                dword ptr [eax + 0x4366f0]
            //   59                   | pop                 ecx

        $sequence_12 = { 4c2be6 45883c24 4c2be6 418bc7 }
            // n = 4, score = 100
            //   4c2be6               | sub                 esp, esi
            //   45883c24             | inc                 ecx
            //   4c2be6               | mov                 eax, edi
            //   418bc7               | shr                 eax, 0x10

        $sequence_13 = { 6aff 8d8c2478010000 6880000000 51 e8???????? 83c410 b8???????? }
            // n = 7, score = 100
            //   6aff                 | push                -1
            //   8d8c2478010000       | lea                 ecx, [esp + 0x178]
            //   6880000000           | push                0x80
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   b8????????           |                     

        $sequence_14 = { 4c2be7 4c8b4340 48b90000000000000080 0fb7d0 }
            // n = 4, score = 100
            //   4c2be7               | sub                 esp, esi
            //   4c8b4340             | mov                 eax, ebx
            //   48b90000000000000080     | shr    eax, 8
            //   0fb7d0               | inc                 ecx

    condition:
        7 of them and filesize < 709632
}