rule win_friedex_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.friedex."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.friedex"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a26 8bc8 e8???????? 57 8bc8 e8???????? 6a65 }
            // n = 7, score = 800
            //   6a26                 | push                0x26
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   57                   | push                edi
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   6a65                 | push                0x65

        $sequence_1 = { 03cd 0fb711 6685d2 75c1 6a2a 5f eb06 }
            // n = 7, score = 800
            //   03cd                 | add                 ecx, ebp
            //   0fb711               | movzx               edx, word ptr [ecx]
            //   6685d2               | test                dx, dx
            //   75c1                 | jne                 0xffffffc3
            //   6a2a                 | push                0x2a
            //   5f                   | pop                 edi
            //   eb06                 | jmp                 8

        $sequence_2 = { eb16 0fb730 663bf7 7416 663bf2 7405 }
            // n = 6, score = 800
            //   eb16                 | jmp                 0x18
            //   0fb730               | movzx               esi, word ptr [eax]
            //   663bf7               | cmp                 si, di
            //   7416                 | je                  0x18
            //   663bf2               | cmp                 si, dx
            //   7405                 | je                  7

        $sequence_3 = { eb0f 03c5 663938 74f9 33c9 }
            // n = 5, score = 800
            //   eb0f                 | jmp                 0x11
            //   03c5                 | add                 eax, ebp
            //   663938               | cmp                 word ptr [eax], di
            //   74f9                 | je                  0xfffffffb
            //   33c9                 | xor                 ecx, ecx

        $sequence_4 = { 85c0 740d ff742408 6a00 6a00 }
            // n = 5, score = 800
            //   85c0                 | test                eax, eax
            //   740d                 | je                  0xf
            //   ff742408             | push                dword ptr [esp + 8]
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_5 = { 8b442408 53 55 56 57 6a2a 5f }
            // n = 7, score = 800
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a2a                 | push                0x2a
            //   5f                   | pop                 edi

        $sequence_6 = { 03f5 eb04 03c5 03cd }
            // n = 4, score = 800
            //   03f5                 | add                 esi, ebp
            //   eb04                 | jmp                 6
            //   03c5                 | add                 eax, ebp
            //   03cd                 | add                 ecx, ebp

        $sequence_7 = { 6a3f 5a 663bfa 7408 8bce 8bc3 }
            // n = 6, score = 800
            //   6a3f                 | push                0x3f
            //   5a                   | pop                 edx
            //   663bfa               | cmp                 di, dx
            //   7408                 | je                  0xa
            //   8bce                 | mov                 ecx, esi
            //   8bc3                 | mov                 eax, ebx

        $sequence_8 = { c744240400000000 8955e8 e8???????? 8d0dbc30a500 890424 894c2404 }
            // n = 6, score = 100
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   8955e8               | mov                 dword ptr [ebp - 0x18], edx
            //   e8????????           |                     
            //   8d0dbc30a500         | lea                 ecx, [0xa530bc]
            //   890424               | mov                 dword ptr [esp], eax
            //   894c2404             | mov                 dword ptr [esp + 4], ecx

        $sequence_9 = { 891424 894c2404 8945f8 e8???????? 8d0d4430a500 }
            // n = 5, score = 100
            //   891424               | mov                 dword ptr [esp], edx
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   e8????????           |                     
            //   8d0d4430a500         | lea                 ecx, [0xa53044]

        $sequence_10 = { c3 55 89e5 83ec10 8b4508 8d0d4430a500 }
            // n = 6, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   83ec10               | sub                 esp, 0x10
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d0d4430a500         | lea                 ecx, [0xa53044]

        $sequence_11 = { 83c404 5d c3 55 89e5 8d055a23a500 }
            // n = 6, score = 100
            //   83c404               | add                 esp, 4
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   8d055a23a500         | lea                 eax, [0xa5235a]

        $sequence_12 = { 894608 890c24 c744240400000000 8955ec e8???????? 8d0dad30a500 890424 }
            // n = 7, score = 100
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   890c24               | mov                 dword ptr [esp], ecx
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   8955ec               | mov                 dword ptr [ebp - 0x14], edx
            //   e8????????           |                     
            //   8d0dad30a500         | lea                 ecx, [0xa530ad]
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_13 = { c7424800100100 8b7de4 c787cc00000000000000 c787c800000000000000 8945dc }
            // n = 5, score = 100
            //   c7424800100100       | mov                 dword ptr [edx + 0x48], 0x11000
            //   8b7de4               | mov                 edi, dword ptr [ebp - 0x1c]
            //   c787cc00000000000000     | mov    dword ptr [edi + 0xcc], 0
            //   c787c800000000000000     | mov    dword ptr [edi + 0xc8], 0
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax

        $sequence_14 = { 8945d0 74e4 31c0 8d0d5a23a500 }
            // n = 4, score = 100
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   74e4                 | je                  0xffffffe6
            //   31c0                 | xor                 eax, eax
            //   8d0d5a23a500         | lea                 ecx, [0xa5235a]

        $sequence_15 = { e8???????? 8d0d4430a500 31d2 8b75f8 89460c 890c24 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8d0d4430a500         | lea                 ecx, [0xa53044]
            //   31d2                 | xor                 edx, edx
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   890c24               | mov                 dword ptr [esp], ecx

    condition:
        7 of them and filesize < 204800
}