rule win_fuwuqidrama_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.fuwuqidrama."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.fuwuqidrama"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8eac040000 c744242813000000 e8???????? 8b86a4040000 8dbea0040000 50 c644242c12 }
            // n = 7, score = 100
            //   8d8eac040000         | lea                 ecx, [esi + 0x4ac]
            //   c744242813000000     | mov                 dword ptr [esp + 0x28], 0x13
            //   e8????????           |                     
            //   8b86a4040000         | mov                 eax, dword ptr [esi + 0x4a4]
            //   8dbea0040000         | lea                 edi, [esi + 0x4a0]
            //   50                   | push                eax
            //   c644242c12           | mov                 byte ptr [esp + 0x2c], 0x12

        $sequence_1 = { 33ee 8b742418 33ee 8bdf 036908 }
            // n = 5, score = 100
            //   33ee                 | xor                 ebp, esi
            //   8b742418             | mov                 esi, dword ptr [esp + 0x18]
            //   33ee                 | xor                 ebp, esi
            //   8bdf                 | mov                 ebx, edi
            //   036908               | add                 ebp, dword ptr [ecx + 8]

        $sequence_2 = { 85f6 57 8be9 0f8483000000 8b7c241c 85ff 7461 }
            // n = 7, score = 100
            //   85f6                 | test                esi, esi
            //   57                   | push                edi
            //   8be9                 | mov                 ebp, ecx
            //   0f8483000000         | je                  0x89
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   85ff                 | test                edi, edi
            //   7461                 | je                  0x63

        $sequence_3 = { 8964241c 50 e8???????? 8b742430 8d4c2424 51 8bce }
            // n = 7, score = 100
            //   8964241c             | mov                 dword ptr [esp + 0x1c], esp
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b742430             | mov                 esi, dword ptr [esp + 0x30]
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi

        $sequence_4 = { 8b742410 85f6 765b 8bce 8bb424a4000000 8bc1 8d7c241c }
            // n = 7, score = 100
            //   8b742410             | mov                 esi, dword ptr [esp + 0x10]
            //   85f6                 | test                esi, esi
            //   765b                 | jbe                 0x5d
            //   8bce                 | mov                 ecx, esi
            //   8bb424a4000000       | mov                 esi, dword ptr [esp + 0xa4]
            //   8bc1                 | mov                 eax, ecx
            //   8d7c241c             | lea                 edi, [esp + 0x1c]

        $sequence_5 = { 8944241c 89542418 0f8cadfeffff 55 e8???????? 83c404 5f }
            // n = 7, score = 100
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   89542418             | mov                 dword ptr [esp + 0x18], edx
            //   0f8cadfeffff         | jl                  0xfffffeb3
            //   55                   | push                ebp
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   5f                   | pop                 edi

        $sequence_6 = { e8???????? 8b442418 46 3bf0 0f8c57ffffff 8b85c0000000 6a04 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   46                   | inc                 esi
            //   3bf0                 | cmp                 esi, eax
            //   0f8c57ffffff         | jl                  0xffffff5d
            //   8b85c0000000         | mov                 eax, dword ptr [ebp + 0xc0]
            //   6a04                 | push                4

        $sequence_7 = { 746d 8b542410 8b442444 8d4c244c 6a00 51 }
            // n = 6, score = 100
            //   746d                 | je                  0x6f
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   8b442444             | mov                 eax, dword ptr [esp + 0x44]
            //   8d4c244c             | lea                 ecx, [esp + 0x4c]
            //   6a00                 | push                0
            //   51                   | push                ecx

        $sequence_8 = { 8b8424f8040000 8d8c24d0010000 50 c78424f404000000000000 e8???????? }
            // n = 5, score = 100
            //   8b8424f8040000       | mov                 eax, dword ptr [esp + 0x4f8]
            //   8d8c24d0010000       | lea                 ecx, [esp + 0x1d0]
            //   50                   | push                eax
            //   c78424f404000000000000     | mov    dword ptr [esp + 0x4f4], 0
            //   e8????????           |                     

        $sequence_9 = { 899708140000 898704140000 ff15???????? 8b16 8d4704 6a00 50 }
            // n = 7, score = 100
            //   899708140000         | mov                 dword ptr [edi + 0x1408], edx
            //   898704140000         | mov                 dword ptr [edi + 0x1404], eax
            //   ff15????????         |                     
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8d4704               | lea                 eax, [edi + 4]
            //   6a00                 | push                0
            //   50                   | push                eax

    condition:
        7 of them and filesize < 245760
}