rule win_ghostsocks_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ghostsocks."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ghostsocks"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b4c2408 8d41ff 8b542404 31db }
            // n = 5, score = 300
            //   e8????????           |                     
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   8d41ff               | lea                 eax, [ecx - 1]
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   31db                 | xor                 ebx, ebx

        $sequence_1 = { e8???????? 8b4c240c 8401 8b442450 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   8401                 | test                byte ptr [ecx], al
            //   8b442450             | mov                 eax, dword ptr [esp + 0x50]

        $sequence_2 = { e8???????? 8b4c2408 8b9424a0050000 8b1a }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   8b9424a0050000       | mov                 edx, dword ptr [esp + 0x5a0]
            //   8b1a                 | mov                 ebx, dword ptr [edx]

        $sequence_3 = { e8???????? 8b4c2408 8b942490000000 8d5a4c 895c2474 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   8b942490000000       | mov                 edx, dword ptr [esp + 0x90]
            //   8d5a4c               | lea                 ebx, [edx + 0x4c]
            //   895c2474             | mov                 dword ptr [esp + 0x74], ebx

        $sequence_4 = { e8???????? 8b4c240c 890f 8908 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   890f                 | mov                 dword ptr [edi], ecx
            //   8908                 | mov                 dword ptr [eax], ecx

        $sequence_5 = { e8???????? 8b4c240c 83f9ff 740d }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   83f9ff               | cmp                 ecx, -1
            //   740d                 | je                  0xf

        $sequence_6 = { e8???????? 8b4c240c 81f900ac0000 7416 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   81f900ac0000         | cmp                 ecx, 0xac00
            //   7416                 | je                  0x18

        $sequence_7 = { e8???????? 8b4c240c 85c9 0f842c010000 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   85c9                 | test                ecx, ecx
            //   0f842c010000         | je                  0x132

        $sequence_8 = { e8???????? 89856068fcff 89956468fcff 8d8d1bc3faff }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856068fcff         | mov                 dword ptr [ebp - 0x397a0], eax
            //   89956468fcff         | mov                 dword ptr [ebp - 0x3979c], edx
            //   8d8d1bc3faff         | lea                 ecx, [ebp - 0x53ce5]

        $sequence_9 = { e8???????? 89856074fbff 89956474fbff a1???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856074fbff         | mov                 dword ptr [ebp - 0x48ba0], eax
            //   89956474fbff         | mov                 dword ptr [ebp - 0x48b9c], edx
            //   a1????????           |                     

        $sequence_10 = { e8???????? 8985605ffdff 8995645ffdff 0fb6856fd5faff }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8985605ffdff         | mov                 dword ptr [ebp - 0x2a0a0], eax
            //   8995645ffdff         | mov                 dword ptr [ebp - 0x2a09c], edx
            //   0fb6856fd5faff       | movzx               eax, byte ptr [ebp - 0x52a91]

        $sequence_11 = { e8???????? 89856076fcff 89956476fcff 8b85d0adfdff }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856076fcff         | mov                 dword ptr [ebp - 0x389a0], eax
            //   89956476fcff         | mov                 dword ptr [ebp - 0x3899c], edx
            //   8b85d0adfdff         | mov                 eax, dword ptr [ebp - 0x25230]

        $sequence_12 = { e8???????? 89856078fbff 89956478fbff 8b0d???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856078fbff         | mov                 dword ptr [ebp - 0x487a0], eax
            //   89956478fbff         | mov                 dword ptr [ebp - 0x4879c], edx
            //   8b0d????????         |                     

        $sequence_13 = { e8???????? 89856071fcff 89956471fcff a1???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856071fcff         | mov                 dword ptr [ebp - 0x38ea0], eax
            //   89956471fcff         | mov                 dword ptr [ebp - 0x38e9c], edx
            //   a1????????           |                     

        $sequence_14 = { e8???????? 89856059fcff 89956459fcff 8b851481fbff }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856059fcff         | mov                 dword ptr [ebp - 0x3a6a0], eax
            //   89956459fcff         | mov                 dword ptr [ebp - 0x3a69c], edx
            //   8b851481fbff         | mov                 eax, dword ptr [ebp - 0x47eec]

        $sequence_15 = { e8???????? 89856077feff 89956477feff 8b8d647ffeff }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89856077feff         | mov                 dword ptr [ebp - 0x188a0], eax
            //   89956477feff         | mov                 dword ptr [ebp - 0x1889c], edx
            //   8b8d647ffeff         | mov                 ecx, dword ptr [ebp - 0x1809c]

    condition:
        7 of them and filesize < 25016320
}