rule win_glitch_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.glitch_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.glitch_pos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d45a0 50 6a03 e8???????? 83c410 8b4508 8b00 }
            // n = 7, score = 100
            //   8d45a0               | lea                 eax, [ebp - 0x60]
            //   50                   | push                eax
            //   6a03                 | push                3
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_1 = { 668985f0feffff 8d4598 50 8d45a8 50 6a02 }
            // n = 6, score = 100
            //   668985f0feffff       | mov                 word ptr [ebp - 0x110], ax
            //   8d4598               | lea                 eax, [ebp - 0x68]
            //   50                   | push                eax
            //   8d45a8               | lea                 eax, [ebp - 0x58]
            //   50                   | push                eax
            //   6a02                 | push                2

        $sequence_2 = { 8b45d0 8b00 ff75d0 ff5040 dbe2 8945cc 837dcc00 }
            // n = 7, score = 100
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ff75d0               | push                dword ptr [ebp - 0x30]
            //   ff5040               | call                dword ptr [eax + 0x40]
            //   dbe2                 | fnclex              
            //   8945cc               | mov                 dword ptr [ebp - 0x34], eax
            //   837dcc00             | cmp                 dword ptr [ebp - 0x34], 0

        $sequence_3 = { 662d0100 0f80b0010000 6689459c 8d459c 50 }
            // n = 5, score = 100
            //   662d0100             | sub                 ax, 1
            //   0f80b0010000         | jo                  0x1b6
            //   6689459c             | mov                 word ptr [ebp - 0x64], ax
            //   8d459c               | lea                 eax, [ebp - 0x64]
            //   50                   | push                eax

        $sequence_4 = { 837de000 7d1a 6894000000 68???????? ff75e4 ff75e0 e8???????? }
            // n = 7, score = 100
            //   837de000             | cmp                 dword ptr [ebp - 0x20], 0
            //   7d1a                 | jge                 0x1c
            //   6894000000           | push                0x94
            //   68????????           |                     
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   e8????????           |                     

        $sequence_5 = { eb07 83a5fcfdffff00 8d45c4 50 8d45cc 50 6a02 }
            // n = 7, score = 100
            //   eb07                 | jmp                 9
            //   83a5fcfdffff00       | and                 dword ptr [ebp - 0x204], 0
            //   8d45c4               | lea                 eax, [ebp - 0x3c]
            //   50                   | push                eax
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   6a02                 | push                2

        $sequence_6 = { 8b00 ffb520ffffff ff5014 dbe2 89851cffffff }
            // n = 5, score = 100
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ffb520ffffff         | push                dword ptr [ebp - 0xe0]
            //   ff5014               | call                dword ptr [eax + 0x14]
            //   dbe2                 | fnclex              
            //   89851cffffff         | mov                 dword ptr [ebp - 0xe4], eax

        $sequence_7 = { c78524ffffff08000000 c7853cffffff3c364600 c78534ffffff08000000 8d45a8 }
            // n = 4, score = 100
            //   c78524ffffff08000000     | mov    dword ptr [ebp - 0xdc], 8
            //   c7853cffffff3c364600     | mov    dword ptr [ebp - 0xc4], 0x46363c
            //   c78534ffffff08000000     | mov    dword ptr [ebp - 0xcc], 8
            //   8d45a8               | lea                 eax, [ebp - 0x58]

        $sequence_8 = { 68a4020000 68???????? ff7508 ffb5d0feffff e8???????? 898550feffff eb07 }
            // n = 7, score = 100
            //   68a4020000           | push                0x2a4
            //   68????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffb5d0feffff         | push                dword ptr [ebp - 0x130]
            //   e8????????           |                     
            //   898550feffff         | mov                 dword ptr [ebp - 0x1b0], eax
            //   eb07                 | jmp                 9

        $sequence_9 = { ff75d8 e8???????? dc9d68ffffff dfe0 }
            // n = 4, score = 100
            //   ff75d8               | push                dword ptr [ebp - 0x28]
            //   e8????????           |                     
            //   dc9d68ffffff         | fcomp               qword ptr [ebp - 0x98]
            //   dfe0                 | fnstsw              ax

    condition:
        7 of them and filesize < 1024000
}