rule win_godlike12_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.godlike12"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c744244800000000 c744244c00000000 89542448 894c244c 8d151e686b00 891424 c74424041f000000 }
            // n = 7, score = 100
            //   c744244800000000     | mov                 dword ptr [esp + 0x48], 0
            //   c744244c00000000     | mov                 dword ptr [esp + 0x4c], 0
            //   89542448             | mov                 dword ptr [esp + 0x48], edx
            //   894c244c             | mov                 dword ptr [esp + 0x4c], ecx
            //   8d151e686b00         | lea                 edx, [0x6b681e]
            //   891424               | mov                 dword ptr [esp], edx
            //   c74424041f000000     | mov                 dword ptr [esp + 4], 0x1f

        $sequence_1 = { c744240802000000 e8???????? 8b44240c 8b4c2414 8d5124 891424 89442404 }
            // n = 7, score = 100
            //   c744240802000000     | mov                 dword ptr [esp + 8], 2
            //   e8????????           |                     
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   8d5124               | lea                 edx, [ecx + 0x24]
            //   891424               | mov                 dword ptr [esp], edx
            //   89442404             | mov                 dword ptr [esp + 4], eax

        $sequence_2 = { f20f59c1 f20f110424 e8???????? f20f10442408 f20f104c246c f20f114c2474 f20f1144246c }
            // n = 7, score = 100
            //   f20f59c1             | mulsd               xmm0, xmm1
            //   f20f110424           | movsd               qword ptr [esp], xmm0
            //   e8????????           |                     
            //   f20f10442408         | movsd               xmm0, qword ptr [esp + 8]
            //   f20f104c246c         | movsd               xmm1, qword ptr [esp + 0x6c]
            //   f20f114c2474         | movsd               qword ptr [esp + 0x74], xmm1
            //   f20f1144246c         | movsd               qword ptr [esp + 0x6c], xmm0

        $sequence_3 = { e8???????? 83c430 c3 8d1de0c56600 891c24 894c2404 89542408 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c430               | add                 esp, 0x30
            //   c3                   | ret                 
            //   8d1de0c56600         | lea                 ebx, [0x66c5e0]
            //   891c24               | mov                 dword ptr [esp], ebx
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   89542408             | mov                 dword ptr [esp + 8], edx

        $sequence_4 = { 8d05e0286600 890424 8d842490000000 89442404 e8???????? 8b442408 8b4c240c }
            // n = 7, score = 100
            //   8d05e0286600         | lea                 eax, [0x6628e0]
            //   890424               | mov                 dword ptr [esp], eax
            //   8d842490000000       | lea                 eax, [esp + 0x90]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   e8????????           |                     
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]

        $sequence_5 = { e8???????? 83c41c c3 894c2430 89542434 90 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   c3                   | ret                 
            //   894c2430             | mov                 dword ptr [esp + 0x30], ecx
            //   89542434             | mov                 dword ptr [esp + 0x34], edx
            //   90                   | nop                 
            //   e8????????           |                     

        $sequence_6 = { eb87 8b44245c 890424 8b05???????? 8b0d???????? 89442404 894c2408 }
            // n = 7, score = 100
            //   eb87                 | jmp                 0xffffff89
            //   8b44245c             | mov                 eax, dword ptr [esp + 0x5c]
            //   890424               | mov                 dword ptr [esp], eax
            //   8b05????????         |                     
            //   8b0d????????         |                     
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   894c2408             | mov                 dword ptr [esp + 8], ecx

        $sequence_7 = { c74424200a000000 83c414 c3 8b4c2418 890c24 88442404 8d05331e6b00 }
            // n = 7, score = 100
            //   c74424200a000000     | mov                 dword ptr [esp + 0x20], 0xa
            //   83c414               | add                 esp, 0x14
            //   c3                   | ret                 
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   890c24               | mov                 dword ptr [esp], ecx
            //   88442404             | mov                 byte ptr [esp + 4], al
            //   8d05331e6b00         | lea                 eax, [0x6b1e33]

        $sequence_8 = { c744240400000000 e8???????? 8d05d6ba6a00 890424 c744240403000000 e8???????? 8b442410 }
            // n = 7, score = 100
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   e8????????           |                     
            //   8d05d6ba6a00         | lea                 eax, [0x6abad6]
            //   890424               | mov                 dword ptr [esp], eax
            //   c744240403000000     | mov                 dword ptr [esp + 4], 3
            //   e8????????           |                     
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]

        $sequence_9 = { e8???????? 8b442424 e9???????? 80fb05 0f8793010000 80fb04 0f8581010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   e9????????           |                     
            //   80fb05               | cmp                 bl, 5
            //   0f8793010000         | ja                  0x199
            //   80fb04               | cmp                 bl, 4
            //   0f8581010000         | jne                 0x187

    condition:
        7 of them and filesize < 8594432
}