rule win_gold_dragon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gold_dragon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gold_dragon"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8890e0924000 eb1c f6c202 7410 8088????????20 8a9405ecfcffff }
            // n = 6, score = 100
            //   8890e0924000         | mov                 byte ptr [eax + 0x4092e0], dl
            //   eb1c                 | jmp                 0x1e
            //   f6c202               | test                dl, 2
            //   7410                 | je                  0x12
            //   8088????????20       |                     
            //   8a9405ecfcffff       | mov                 dl, byte ptr [ebp + eax - 0x314]

        $sequence_1 = { 8bc8 83e01f c1f905 8d04c0 8b0c8d00954000 8d44810c 50 }
            // n = 7, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   83e01f               | and                 eax, 0x1f
            //   c1f905               | sar                 ecx, 5
            //   8d04c0               | lea                 eax, [eax + eax*8]
            //   8b0c8d00954000       | mov                 ecx, dword ptr [ecx*4 + 0x409500]
            //   8d44810c             | lea                 eax, [ecx + eax*4 + 0xc]
            //   50                   | push                eax

        $sequence_2 = { 85c0 a3???????? 0f84ad060000 8b35???????? 68???????? }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   a3????????           |                     
            //   0f84ad060000         | je                  0x6b3
            //   8b35????????         |                     
            //   68????????           |                     

        $sequence_3 = { 8bf1 8bc1 c1fe05 83e01f 8b34b500954000 8d04c0 8b0486 }
            // n = 7, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   8bc1                 | mov                 eax, ecx
            //   c1fe05               | sar                 esi, 5
            //   83e01f               | and                 eax, 0x1f
            //   8b34b500954000       | mov                 esi, dword ptr [esi*4 + 0x409500]
            //   8d04c0               | lea                 eax, [eax + eax*8]
            //   8b0486               | mov                 eax, dword ptr [esi + eax*4]

        $sequence_4 = { 41 8079ff00 0f8547ffffff 8bc6 8088e193400008 }
            // n = 5, score = 100
            //   41                   | inc                 ecx
            //   8079ff00             | cmp                 byte ptr [ecx - 1], 0
            //   0f8547ffffff         | jne                 0xffffff4d
            //   8bc6                 | mov                 eax, esi
            //   8088e193400008       | or                  byte ptr [eax + 0x4093e1], 8

        $sequence_5 = { 8d8560ffffff 68???????? 50 e8???????? ffb64c834000 8d8560ffffff 50 }
            // n = 7, score = 100
            //   8d8560ffffff         | lea                 eax, [ebp - 0xa0]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   ffb64c834000         | push                dword ptr [esi + 0x40834c]
            //   8d8560ffffff         | lea                 eax, [ebp - 0xa0]
            //   50                   | push                eax

        $sequence_6 = { 51 ffd6 85c0 a3???????? 0f84dd030000 8b15???????? }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   a3????????           |                     
            //   0f84dd030000         | je                  0x3e3
            //   8b15????????         |                     

        $sequence_7 = { 50 ffd6 85c0 a3???????? 0f8478060000 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   a3????????           |                     
            //   0f8478060000         | je                  0x67e

        $sequence_8 = { 83e01f 8b0c8d00954000 8d04c0 8d0481 8b4dfc }
            // n = 5, score = 100
            //   83e01f               | and                 eax, 0x1f
            //   8b0c8d00954000       | mov                 ecx, dword ptr [ecx*4 + 0x409500]
            //   8d04c0               | lea                 eax, [eax + eax*8]
            //   8d0481               | lea                 eax, [ecx + eax*4]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_9 = { 68???????? 50 ffd6 85c0 a3???????? 0f84d8050000 8b0d???????? }
            // n = 7, score = 100
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   a3????????           |                     
            //   0f84d8050000         | je                  0x5de
            //   8b0d????????         |                     

    condition:
        7 of them and filesize < 90112
}