rule win_goldenspy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.goldenspy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.goldenspy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d8d00ffffff e8???????? 8d4638 c645fc1d 50 8d8d18ffffff e8???????? }
            // n = 7, score = 100
            //   8d8d00ffffff         | lea                 ecx, [ebp - 0x100]
            //   e8????????           |                     
            //   8d4638               | lea                 eax, [esi + 0x38]
            //   c645fc1d             | mov                 byte ptr [ebp - 4], 0x1d
            //   50                   | push                eax
            //   8d8d18ffffff         | lea                 ecx, [ebp - 0xe8]
            //   e8????????           |                     

        $sequence_1 = { 50 e8???????? 83c404 c786c800000000000000 83bed000000000 7413 8b86cc000000 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c786c800000000000000     | mov    dword ptr [esi + 0xc8], 0
            //   83bed000000000       | cmp                 dword ptr [esi + 0xd0], 0
            //   7413                 | je                  0x15
            //   8b86cc000000         | mov                 eax, dword ptr [esi + 0xcc]

        $sequence_2 = { ff4724 83fa10 7228 8b4dd0 42 8bc1 81fa00100000 }
            // n = 7, score = 100
            //   ff4724               | inc                 dword ptr [edi + 0x24]
            //   83fa10               | cmp                 edx, 0x10
            //   7228                 | jb                  0x2a
            //   8b4dd0               | mov                 ecx, dword ptr [ebp - 0x30]
            //   42                   | inc                 edx
            //   8bc1                 | mov                 eax, ecx
            //   81fa00100000         | cmp                 edx, 0x1000

        $sequence_3 = { 68???????? e8???????? a1???????? 83c40c c787d400000004000000 53 ffb7cc000000 }
            // n = 7, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   a1????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c787d400000004000000     | mov    dword ptr [edi + 0xd4], 4
            //   53                   | push                ebx
            //   ffb7cc000000         | push                dword ptr [edi + 0xcc]

        $sequence_4 = { 6a00 6a02 c745fc00000000 ff15???????? 8b95b8feffff 8bd8 83fbff }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   ff15????????         |                     
            //   8b95b8feffff         | mov                 edx, dword ptr [ebp - 0x148]
            //   8bd8                 | mov                 ebx, eax
            //   83fbff               | cmp                 ebx, -1

        $sequence_5 = { 83c408 c3 8b4df0 e9???????? 8b4df0 83c14c }
            // n = 6, score = 100
            //   83c408               | add                 esp, 8
            //   c3                   | ret                 
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   e9????????           |                     
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   83c14c               | add                 ecx, 0x4c

        $sequence_6 = { e8???????? 83c408 c3 6a10 8b45f0 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c3                   | ret                 
            //   6a10                 | push                0x10
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]

        $sequence_7 = { 745f 51 c745fc00000000 e8???????? 83f8ff 7459 8b450c }
            // n = 7, score = 100
            //   745f                 | je                  0x61
            //   51                   | push                ecx
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   7459                 | je                  0x5b
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_8 = { 8d8d18ffffff e8???????? 8b55ec 83fa10 7228 8b4dd8 }
            // n = 6, score = 100
            //   8d8d18ffffff         | lea                 ecx, [ebp - 0xe8]
            //   e8????????           |                     
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   83fa10               | cmp                 edx, 0x10
            //   7228                 | jb                  0x2a
            //   8b4dd8               | mov                 ecx, dword ptr [ebp - 0x28]

        $sequence_9 = { 8b01 8b400c ffd0 8945e0 8d45e0 c645fc2c 50 }
            // n = 7, score = 100
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   ffd0                 | call                eax
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   c645fc2c             | mov                 byte ptr [ebp - 4], 0x2c
            //   50                   | push                eax

    condition:
        7 of them and filesize < 1081344
}