rule win_goopic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.goopic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.goopic"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff5158 8b442410 ff742430 50 8b08 }
            // n = 5, score = 100
            //   ff5158               | call                dword ptr [ecx + 0x58]
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   ff742430             | push                dword ptr [esp + 0x30]
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_1 = { 68???????? ff15???????? 8d85f8f7ffff 50 6a02 }
            // n = 5, score = 100
            //   68????????           |                     
            //   ff15????????         |                     
            //   8d85f8f7ffff         | lea                 eax, [ebp - 0x808]
            //   50                   | push                eax
            //   6a02                 | push                2

        $sequence_2 = { ff15???????? 83bdf0efffff00 7409 83bdf8efffff00 77a4 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   83bdf0efffff00       | cmp                 dword ptr [ebp - 0x1010], 0
            //   7409                 | je                  0xb
            //   83bdf8efffff00       | cmp                 dword ptr [ebp - 0x1008], 0
            //   77a4                 | ja                  0xffffffa6

        $sequence_3 = { 751d 6683bdfcfeffff37 7513 b801000000 8b4dfc 33cd }
            // n = 6, score = 100
            //   751d                 | jne                 0x1f
            //   6683bdfcfeffff37     | cmp                 word ptr [ebp - 0x104], 0x37
            //   7513                 | jne                 0x15
            //   b801000000           | mov                 eax, 1
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp

        $sequence_4 = { 8945fc 57 6a52 6a40 ff15???????? 8bf8 }
            // n = 6, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   57                   | push                edi
            //   6a52                 | push                0x52
            //   6a40                 | push                0x40
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_5 = { 68???????? 8d85fcf7ffff 50 ff15???????? 6a02 68???????? ff15???????? }
            // n = 7, score = 100
            //   68????????           |                     
            //   8d85fcf7ffff         | lea                 eax, [ebp - 0x804]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6a02                 | push                2
            //   68????????           |                     
            //   ff15????????         |                     

        $sequence_6 = { 744b 83f873 7446 83f874 }
            // n = 4, score = 100
            //   744b                 | je                  0x4d
            //   83f873               | cmp                 eax, 0x73
            //   7446                 | je                  0x48
            //   83f874               | cmp                 eax, 0x74

        $sequence_7 = { 8d4910 660f70c000 83c004 660ffec1 f30f7f41f0 3d00010000 7ce1 }
            // n = 7, score = 100
            //   8d4910               | lea                 ecx, [ecx + 0x10]
            //   660f70c000           | pshufd              xmm0, xmm0, 0
            //   83c004               | add                 eax, 4
            //   660ffec1             | paddd               xmm0, xmm1
            //   f30f7f41f0           | movdqu              xmmword ptr [ecx - 0x10], xmm0
            //   3d00010000           | cmp                 eax, 0x100
            //   7ce1                 | jl                  0xffffffe3

        $sequence_8 = { 7cb2 33ff 397d08 766e 41 81e1ff000080 }
            // n = 6, score = 100
            //   7cb2                 | jl                  0xffffffb4
            //   33ff                 | xor                 edi, edi
            //   397d08               | cmp                 dword ptr [ebp + 8], edi
            //   766e                 | jbe                 0x70
            //   41                   | inc                 ecx
            //   81e1ff000080         | and                 ecx, 0x800000ff

        $sequence_9 = { a3???????? 85c0 750a ff742424 ff15???????? }
            // n = 5, score = 100
            //   a3????????           |                     
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   ff742424             | push                dword ptr [esp + 0x24]
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 114688
}