rule win_gootkit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gootkit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gootkit"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83ec30 53 8bc1 0f57c0 56 57 8d4df8 }
            // n = 7, score = 1700
            //   83ec30               | sub                 esp, 0x30
            //   53                   | push                ebx
            //   8bc1                 | mov                 eax, ecx
            //   0f57c0               | xorps               xmm0, xmm0
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d4df8               | lea                 ecx, [ebp - 8]

        $sequence_1 = { 833b00 7406 837b0400 7502 }
            // n = 4, score = 1700
            //   833b00               | cmp                 dword ptr [ebx], 0
            //   7406                 | je                  8
            //   837b0400             | cmp                 dword ptr [ebx + 4], 0
            //   7502                 | jne                 4

        $sequence_2 = { 7407 33c9 e8???????? 8b5dfc ff75f4 6a00 ff15???????? }
            // n = 7, score = 1700
            //   7407                 | je                  9
            //   33c9                 | xor                 ecx, ecx
            //   e8????????           |                     
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_3 = { 6a02 5b 8975f0 e8???????? 8d45fc 33d2 }
            // n = 6, score = 1700
            //   6a02                 | push                2
            //   5b                   | pop                 ebx
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   e8????????           |                     
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   33d2                 | xor                 edx, edx

        $sequence_4 = { 59 85c0 0f84af000000 2bc6 8bce 8bd0 e8???????? }
            // n = 7, score = 1700
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   0f84af000000         | je                  0xb5
            //   2bc6                 | sub                 eax, esi
            //   8bce                 | mov                 ecx, esi
            //   8bd0                 | mov                 edx, eax
            //   e8????????           |                     

        $sequence_5 = { 51 8bcb e8???????? 59 85c0 740c }
            // n = 6, score = 1700
            //   51                   | push                ecx
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   740c                 | je                  0xe

        $sequence_6 = { ff15???????? 50 ffd6 8bc7 893d???????? }
            // n = 5, score = 1700
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8bc7                 | mov                 eax, edi
            //   893d????????         |                     

        $sequence_7 = { 55 8bec 83ec14 53 57 8955f4 8bd9 }
            // n = 7, score = 1700
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec14               | sub                 esp, 0x14
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   8bd9                 | mov                 ebx, ecx

        $sequence_8 = { f3aa 68???????? ff15???????? 50 }
            // n = 4, score = 1200
            //   f3aa                 | rep stosb           byte ptr es:[edi], al
            //   68????????           |                     
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_9 = { 8b7df4 32c0 8b4de4 f3aa }
            // n = 4, score = 1200
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   32c0                 | xor                 al, al
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   f3aa                 | rep stosb           byte ptr es:[edi], al

        $sequence_10 = { 50 68???????? ff15???????? 85c0 7505 e8???????? }
            // n = 6, score = 1100
            //   50                   | push                eax
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7505                 | jne                 7
            //   e8????????           |                     

        $sequence_11 = { 50 e8???????? 83c40c 68fd000000 }
            // n = 4, score = 1100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   68fd000000           | push                0xfd

        $sequence_12 = { 50 8b4508 8b00 99 52 50 }
            // n = 6, score = 1000
            //   50                   | push                eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   99                   | cdq                 
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_13 = { c705????????01000000 c705????????02000000 8be5 5d c3 55 }
            // n = 6, score = 900
            //   c705????????01000000     |     
            //   c705????????02000000     |     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp

        $sequence_14 = { 833d????????00 750a 6a32 ff15???????? }
            // n = 4, score = 800
            //   833d????????00       |                     
            //   750a                 | jne                 0xc
            //   6a32                 | push                0x32
            //   ff15????????         |                     

        $sequence_15 = { e8???????? 6a0c 6a08 ff15???????? }
            // n = 4, score = 800
            //   e8????????           |                     
            //   6a0c                 | push                0xc
            //   6a08                 | push                8
            //   ff15????????         |                     

        $sequence_16 = { 6808020000 6a00 ff15???????? 50 ff15???????? }
            // n = 5, score = 800
            //   6808020000           | push                0x208
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_17 = { 6a02 ff15???????? 6888130000 ff15???????? }
            // n = 4, score = 700
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   6888130000           | push                0x1388
            //   ff15????????         |                     

        $sequence_18 = { 8d45fc 50 6a01 6a01 6a00 6800000002 }
            // n = 6, score = 600
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   6a01                 | push                1
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6800000002           | push                0x2000000

        $sequence_19 = { e8???????? 85c0 750c c705????????03000000 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   c705????????03000000     |     

        $sequence_20 = { e8???????? 85c0 740d 6810270000 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   740d                 | je                  0xf
            //   6810270000           | push                0x2710

        $sequence_21 = { 68???????? 51 51 ff15???????? 50 }
            // n = 5, score = 300
            //   68????????           |                     
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_22 = { 53 53 53 8901 }
            // n = 4, score = 300
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   8901                 | mov                 dword ptr [ecx], eax

        $sequence_23 = { 83faff 7508 ff15???????? 8bd0 }
            // n = 4, score = 200
            //   83faff               | cmp                 edx, -1
            //   7508                 | jne                 0xa
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax

        $sequence_24 = { ff15???????? ffc3 83fb0a 7cd5 33c0 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   ffc3                 | inc                 ebx
            //   83fb0a               | cmp                 ebx, 0xa
            //   7cd5                 | jl                  0xffffffd7
            //   33c0                 | xor                 eax, eax

        $sequence_25 = { 7550 ff15???????? 8bf8 893d???????? }
            // n = 4, score = 200
            //   7550                 | jne                 0x52
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   893d????????         |                     

        $sequence_26 = { 8d4204 3bc8 7344 2bca }
            // n = 4, score = 200
            //   8d4204               | lea                 eax, [edx + 4]
            //   3bc8                 | cmp                 ecx, eax
            //   7344                 | jae                 0x46
            //   2bca                 | sub                 ecx, edx

        $sequence_27 = { 0f104850 0f114f50 0f104060 0f114760 8b4070 894770 }
            // n = 6, score = 200
            //   0f104850             | movups              xmm1, xmmword ptr [eax + 0x50]
            //   0f114f50             | movups              xmmword ptr [edi + 0x50], xmm1
            //   0f104060             | movups              xmm0, xmmword ptr [eax + 0x60]
            //   0f114760             | movups              xmmword ptr [edi + 0x60], xmm0
            //   8b4070               | mov                 eax, dword ptr [eax + 0x70]
            //   894770               | mov                 dword ptr [edi + 0x70], eax

        $sequence_28 = { 8bf2 8d4601 57 50 }
            // n = 4, score = 200
            //   8bf2                 | mov                 esi, edx
            //   8d4601               | lea                 eax, [esi + 1]
            //   57                   | push                edi
            //   50                   | push                eax

        $sequence_29 = { 8b8de4fdffff 8b36 85f6 75a2 8b3f }
            // n = 5, score = 200
            //   8b8de4fdffff         | mov                 ecx, dword ptr [ebp - 0x21c]
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   85f6                 | test                esi, esi
            //   75a2                 | jne                 0xffffffa4
            //   8b3f                 | mov                 edi, dword ptr [edi]

        $sequence_30 = { 53 33db e8???????? ff15???????? 8bc8 }
            // n = 5, score = 200
            //   53                   | push                ebx
            //   33db                 | xor                 ebx, ebx
            //   e8????????           |                     
            //   ff15????????         |                     
            //   8bc8                 | mov                 ecx, eax

        $sequence_31 = { 0f104010 0f110f 0f104820 0f114710 }
            // n = 4, score = 200
            //   0f104010             | movups              xmm0, xmmword ptr [eax + 0x10]
            //   0f110f               | movups              xmmword ptr [edi], xmm1
            //   0f104820             | movups              xmm1, xmmword ptr [eax + 0x20]
            //   0f114710             | movups              xmmword ptr [edi + 0x10], xmm0

        $sequence_32 = { 3cff 7552 807e0125 754c 8b5e02 }
            // n = 5, score = 200
            //   3cff                 | cmp                 al, 0xff
            //   7552                 | jne                 0x54
            //   807e0125             | cmp                 byte ptr [esi + 1], 0x25
            //   754c                 | jne                 0x4e
            //   8b5e02               | mov                 ebx, dword ptr [esi + 2]

        $sequence_33 = { ff15???????? 85c0 7510 8d4864 ff15???????? }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7510                 | jne                 0x12
            //   8d4864               | lea                 ecx, [eax + 0x64]
            //   ff15????????         |                     

        $sequence_34 = { 0f104050 0f114f40 0f104860 0f114750 }
            // n = 4, score = 200
            //   0f104050             | movups              xmm0, xmmword ptr [eax + 0x50]
            //   0f114f40             | movups              xmmword ptr [edi + 0x40], xmm1
            //   0f104860             | movups              xmm1, xmmword ptr [eax + 0x60]
            //   0f114750             | movups              xmmword ptr [edi + 0x50], xmm0

        $sequence_35 = { 0f114710 0f104030 0f114f20 0f104840 0f114730 0f104050 0f114f40 }
            // n = 7, score = 200
            //   0f114710             | movups              xmmword ptr [edi + 0x10], xmm0
            //   0f104030             | movups              xmm0, xmmword ptr [eax + 0x30]
            //   0f114f20             | movups              xmmword ptr [edi + 0x20], xmm1
            //   0f104840             | movups              xmm1, xmmword ptr [eax + 0x40]
            //   0f114730             | movups              xmmword ptr [edi + 0x30], xmm0
            //   0f104050             | movups              xmm0, xmmword ptr [eax + 0x50]
            //   0f114f40             | movups              xmmword ptr [edi + 0x40], xmm1

        $sequence_36 = { 7323 8b33 eb19 3ce9 7508 8b4601 83c605 }
            // n = 7, score = 200
            //   7323                 | jae                 0x25
            //   8b33                 | mov                 esi, dword ptr [ebx]
            //   eb19                 | jmp                 0x1b
            //   3ce9                 | cmp                 al, 0xe9
            //   7508                 | jne                 0xa
            //   8b4601               | mov                 eax, dword ptr [esi + 1]
            //   83c605               | add                 esi, 5

    condition:
        7 of them and filesize < 516096
}