rule win_graphical_neutrino_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.graphical_neutrino."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.graphical_neutrino"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4883ec28 48b8abaaaaaaaaaaaaaa 4889d3 4989cc 4889d6 4829cb }
            // n = 6, score = 500
            //   4883ec28             | dec                 eax
            //   48b8abaaaaaaaaaaaaaa     | lea    ecx, [0x3e3b0]
            //   4889d3               | je                  0x1568
            //   4989cc               | dec                 esp
            //   4889d6               | mov                 edx, ebp
            //   4829cb               | dec                 eax

        $sequence_1 = { 4889d7 66c703302e f3aa 498d442c02 }
            // n = 4, score = 500
            //   4889d7               | mov                 esp, ecx
            //   66c703302e           | dec                 eax
            //   f3aa                 | sub                 esp, 0x28
            //   498d442c02           | dec                 eax

        $sequence_2 = { 488b8c2488000000 e8???????? 488d8c2458040000 e8???????? 4c89e9 }
            // n = 5, score = 500
            //   488b8c2488000000     | lea                 eax, [0x3bbc2]
            //   e8????????           |                     
            //   488d8c2458040000     | dec                 eax
            //   e8????????           |                     
            //   4c89e9               | lea                 ecx, [0x3bfce]

        $sequence_3 = { 42c6442d5aef c6440d5abf c644155abd b800020000 4829d8 }
            // n = 5, score = 500
            //   42c6442d5aef         | lea                 ecx, [0x412fa]
            //   c6440d5abf           | test                al, al
            //   c644155abd           | jne                 0x971
            //   b800020000           | dec                 eax
            //   4829d8               | lea                 ecx, [0x3e5fa]

        $sequence_4 = { 4889d9 e8???????? 488d842488010000 4889ea 48895c2460 4889c1 }
            // n = 6, score = 500
            //   4889d9               | add                 byte ptr [eax], al
            //   e8????????           |                     
            //   488d842488010000     | dec                 eax
            //   4889ea               | lea                 ecx, [0x41f92]
            //   48895c2460           | je                  0x1d63
            //   4889c1               | dec                 ecx

        $sequence_5 = { 488b4c2458 e8???????? 4c89e1 e8???????? 4889d9 e8???????? 488b4c2450 }
            // n = 7, score = 500
            //   488b4c2458           | push                ebx
            //   e8????????           |                     
            //   4c89e1               | dec                 eax
            //   e8????????           |                     
            //   4889d9               | sub                 esp, 0x28
            //   e8????????           |                     
            //   488b4c2450           | dec                 eax

        $sequence_6 = { 4889e9 e8???????? 90 4881c4b8010000 5b }
            // n = 5, score = 500
            //   4889e9               | dec                 eax
            //   e8????????           |                     
            //   90                   | lea                 ecx, [0xffffd678]
            //   4881c4b8010000       | dec                 eax
            //   5b                   | lea                 ecx, [0x41361]

        $sequence_7 = { 488b8c24b0000000 e8???????? 488b8c2498000000 e8???????? }
            // n = 4, score = 500
            //   488b8c24b0000000     | mov                 dword ptr [ecx], eax
            //   e8????????           |                     
            //   488b8c2498000000     | inc                 esp
            //   e8????????           |                     

        $sequence_8 = { 4c89f9 e8???????? 488b4c2448 e8???????? 4c89f1 e8???????? 488b4c2438 }
            // n = 7, score = 500
            //   4c89f9               | lea                 ecx, [0x3bcc2]
            //   e8????????           |                     
            //   488b4c2448           | dec                 eax
            //   e8????????           |                     
            //   4c89f1               | lea                 ecx, [0xffff9db1]
            //   e8????????           |                     
            //   488b4c2438           | dec                 eax

        $sequence_9 = { 4c8da424c0000000 48c78424c800000002000000 48898424a0000000 4c89e2 48898424c0000000 488d8424e8040000 4889c1 }
            // n = 7, score = 500
            //   4c8da424c0000000     | jne                 0xf5
            //   48c78424c800000002000000     | inc    esp
            //   48898424a0000000     | mov                 edx, eax
            //   4c89e2               | dec                 eax
            //   48898424c0000000     | lea                 ecx, [0x254ed]
            //   488d8424e8040000     | dec                 esp
            //   4889c1               | mov                 dword ptr [eax + 0x18], esp

    condition:
        7 of them and filesize < 674816
}