rule win_grateful_pos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.grateful_pos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grateful_pos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7407 b8f6ffffff eb02 33c0 }
            // n = 4, score = 600
            //   7407                 | je                  9
            //   b8f6ffffff           | mov                 eax, 0xfffffff6
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 7411 e8???????? e8???????? 33c0 e9???????? }
            // n = 5, score = 600
            //   7411                 | je                  0x13
            //   e8????????           |                     
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     

        $sequence_2 = { b8feffffff eb1a b8fdffffff eb13 b8fcffffff }
            // n = 5, score = 600
            //   b8feffffff           | mov                 eax, 0xfffffffe
            //   eb1a                 | jmp                 0x1c
            //   b8fdffffff           | mov                 eax, 0xfffffffd
            //   eb13                 | jmp                 0x15
            //   b8fcffffff           | mov                 eax, 0xfffffffc

        $sequence_3 = { e8???????? 99 b980ee3600 f7f9 }
            // n = 4, score = 600
            //   e8????????           |                     
            //   99                   | cdq                 
            //   b980ee3600           | mov                 ecx, 0x36ee80
            //   f7f9                 | idiv                ecx

        $sequence_4 = { eb07 b8fcffffff eb02 33c0 }
            // n = 4, score = 600
            //   eb07                 | jmp                 9
            //   b8fcffffff           | mov                 eax, 0xfffffffc
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_5 = { 83f801 7510 e8???????? e8???????? }
            // n = 4, score = 600
            //   83f801               | cmp                 eax, 1
            //   7510                 | jne                 0x12
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_6 = { 0f858d000000 833d????????00 745a 6a28 8d9574ffffff }
            // n = 5, score = 500
            //   0f858d000000         | mov                 eax, 0xfffffffd
            //   833d????????00       |                     
            //   745a                 | jmp                 0x1a
            //   6a28                 | mov                 eax, 0xfffffffc
            //   8d9574ffffff         | mov                 edx, dword ptr [ebp + ecx*4 - 0x2c]

        $sequence_7 = { e8???????? 83c40c 8b45fc 8b4d0c 8b510c }
            // n = 5, score = 500
            //   e8????????           |                     
            //   83c40c               | mov                 esi, dword ptr [ebp - 0x2000c]
            //   8b45fc               | add                 esi, dword ptr [ebp - 0x20008]
            //   8b4d0c               | shr                 esi, 3
            //   8b510c               | mov                 eax, dword ptr [ebp + 8]

        $sequence_8 = { e8???????? 83c410 8b85e0fbffff 0385dcfbffff }
            // n = 4, score = 500
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8b85e0fbffff         | mov                 eax, dword ptr [ebp - 0x420]
            //   0385dcfbffff         | add                 eax, dword ptr [ebp - 0x424]

        $sequence_9 = { 83c408 85c0 0f8451010000 c605????????01 c68572f9ffff00 }
            // n = 5, score = 500
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f8451010000         | je                  0x157
            //   c605????????01       |                     
            //   c68572f9ffff00       | mov                 byte ptr [ebp - 0x68e], 0

        $sequence_10 = { 8b4dbc 894dcc 8b55d0 8955b4 8b45d0 83e801 }
            // n = 6, score = 500
            //   8b4dbc               | push                0
            //   894dcc               | lea                 edx, [ebp - 0x28b]
            //   8b55d0               | push                edx
            //   8955b4               | push                ecx
            //   8b45d0               | jmp                 0xf
            //   83e801               | add                 eax, 1

        $sequence_11 = { 8bb5f4fffdff 03b5f8fffdff c1ee03 8b4508 8b7810 8b85f4fffdff 0385f8fffdff }
            // n = 7, score = 500
            //   8bb5f4fffdff         | mov                 dword ptr [ebp - 0x48], edx
            //   03b5f8fffdff         | mov                 eax, dword ptr [ebp - 0x38]
            //   c1ee03               | add                 eax, dword ptr [ebp - 0x48]
            //   8b4508               | jne                 0x93
            //   8b7810               | je                  0x5c
            //   8b85f4fffdff         | push                0x28
            //   0385f8fffdff         | lea                 edx, [ebp - 0x8c]

        $sequence_12 = { 51 c705????????00000000 eb0d a1???????? 83c001 a3???????? 8b4d08 }
            // n = 7, score = 500
            //   51                   | mov                 ecx, dword ptr [ebp + 0xc]
            //   c705????????00000000     |     
            //   eb0d                 | mov                 edx, dword ptr [ecx + 0xc]
            //   a1????????           |                     
            //   83c001               | mov                 byte ptr [ebp - 0x28c], cl
            //   a3????????           |                     
            //   8b4d08               | push                0xff

        $sequence_13 = { 888d74fdffff 68ff000000 6a00 8d9575fdffff 52 }
            // n = 5, score = 500
            //   888d74fdffff         | mov                 edi, dword ptr [eax + 0x10]
            //   68ff000000           | mov                 eax, dword ptr [ebp - 0x2000c]
            //   6a00                 | add                 eax, dword ptr [ebp - 0x20008]
            //   8d9575fdffff         | add                 esp, 0xc
            //   52                   | mov                 eax, dword ptr [ebp - 4]

        $sequence_14 = { 888424c1000000 b801000000 486bc012 488d0df2cb0100 0fbe0401 83f04d }
            // n = 6, score = 200
            //   888424c1000000       | mov                 byte ptr [esp + 0xc1], al
            //   b801000000           | mov                 eax, 1
            //   486bc012             | dec                 eax
            //   488d0df2cb0100       | imul                eax, eax, 0x12
            //   0fbe0401             | dec                 eax
            //   83f04d               | lea                 ecx, [0x1cbf2]

        $sequence_15 = { 03d0 69d290010000 3bca 7414 488d3db7b5feff 4963e9 448b94af14690300 }
            // n = 7, score = 200
            //   03d0                 | movsx               eax, byte ptr [ecx + eax]
            //   69d290010000         | xor                 eax, 0x4d
            //   3bca                 | add                 edx, eax
            //   7414                 | imul                edx, edx, 0x190
            //   488d3db7b5feff       | cmp                 ecx, edx
            //   4963e9               | je                  0x16
            //   448b94af14690300     | dec                 eax

    condition:
        7 of them and filesize < 3964928
}