rule win_grimplant_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.grimplant."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.grimplant"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb3d 0f108424a8000000 0f11842468010000 4c8b942480000000 488b542438 4c8b642430 488b842490000000 }
            // n = 7, score = 100
            //   eb3d                 | dec                 eax
            //   0f108424a8000000     | add                 esp, 0x1d8
            //   0f11842468010000     | ret                 
            //   4c8b942480000000     | dec                 eax
            //   488b542438           | lea                 eax, [0x21334e]
            //   4c8b642430           | dec                 eax
            //   488b842490000000     | mov                 eax, ebx

        $sequence_1 = { e8???????? 90 88442418 885c2419 884c241a 48897c2420 4889742428 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   88442418             | mov                 ecx, dword ptr [esp + 0xd0]
            //   885c2419             | dec                 eax
            //   884c241a             | lea                 eax, [0xf4ebe]
            //   48897c2420           | dec                 eax
            //   4889742428           | mov                 dword ptr [eax + 8], 0x11

        $sequence_2 = { ffd1 488bac2460010000 4881c468010000 c3 488b842470010000 6690 e8???????? }
            // n = 7, score = 100
            //   ffd1                 | mov                 ebp, dword ptr [esp]
            //   488bac2460010000     | dec                 eax
            //   4881c468010000       | add                 esp, 8
            //   c3                   | nop                 
            //   488b842470010000     | ret                 
            //   6690                 | jmp                 0x1fdd
            //   e8????????           |                     

        $sequence_3 = { eb0f 4889c7 488d1537941c00 e8???????? 488d053cdd1300 488b9c24c0000000 488d0d15f31e00 }
            // n = 7, score = 100
            //   eb0f                 | mov                 edi, eax
            //   4889c7               | dec                 eax
            //   488d1537941c00       | mov                 dword ptr [eax + 8], 0x38
            //   e8????????           |                     
            //   488d053cdd1300       | dec                 eax
            //   488b9c24c0000000     | lea                 ecx, [0x1c9787]
            //   488d0d15f31e00       | dec                 eax

        $sequence_4 = { ffd2 4885db 0f8ec4000000 488b4c2470 488b5130 488b442478 ffd2 }
            // n = 7, score = 100
            //   ffd2                 | mov                 ecx, dword ptr [esp + 0x48]
            //   4885db               | dec                 eax
            //   0f8ec4000000         | mov                 eax, dword ptr [esp + 0x80]
            //   488b4c2470           | dec                 eax
            //   488b5130             | mov                 dword ptr [esp + 0x48], ecx
            //   488b442478           | dec                 eax
            //   ffd2                 | mov                 dword ptr [esp + 0x80], eax

        $sequence_5 = { e8???????? 488b942490000000 48895010 833d????????00 7517 488bb42498000000 48897018 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b942490000000     | dec                 eax
            //   48895010             | mov                 eax, dword ptr [edx]
            //   833d????????00       |                     
            //   7517                 | dec                 eax
            //   488bb42498000000     | mov                 dword ptr [esp + 0x60], ebx
            //   48897018             | dec                 eax

        $sequence_6 = { ffd1 b905000000 4889c7 4889de 31c0 488d1de47e3900 e8???????? }
            // n = 7, score = 100
            //   ffd1                 | dec                 eax
            //   b905000000           | mov                 edi, eax
            //   4889c7               | dec                 eax
            //   4889de               | mov                 eax, dword ptr [esp + 0x60]
            //   31c0                 | dec                 eax
            //   488d1de47e3900       | mov                 dword ptr [esp + 0x58], eax
            //   e8????????           |                     

        $sequence_7 = { eb20 488d7830 488b4c2470 0f1f440000 e8???????? 488b7c2440 e8???????? }
            // n = 7, score = 100
            //   eb20                 | mov                 edx, dword ptr [esp + 0x28]
            //   488d7830             | dec                 eax
            //   488b4c2470           | test                edx, edx
            //   0f1f440000           | jmp                 0x137d
            //   e8????????           |                     
            //   488b7c2440           | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { 8d0cc9 8d4940 48c1e906 4801c1 488b542438 48010a b801000000 }
            // n = 7, score = 100
            //   8d0cc9               | test                esi, esi
            //   8d4940               | jne                 0x1103
            //   48c1e906             | test                cl, cl
            //   4801c1               | je                  0xd4b
            //   488b542438           | dec                 eax
            //   48010a               | mov                 ecx, dword ptr [esp + 0xd0]
            //   b801000000           | dec                 eax

        $sequence_9 = { eb23 4889c1 48c1e004 488d15882e9000 48c7040200000000 48c744020800000000 488d4101 }
            // n = 7, score = 100
            //   eb23                 | ret                 
            //   4889c1               | dec                 eax
            //   48c1e004             | lea                 eax, [esp + 0x110]
            //   488d15882e9000       | jmp                 0x1e85
            //   48c7040200000000     | dec                 eax
            //   48c744020800000000     | mov    ebp, dword ptr [esp + 0xa8]
            //   488d4101             | dec                 eax

    condition:
        7 of them and filesize < 19940352
}