rule win_gspy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gspy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gspy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 ff5514 46 833cb700 8d04b7 75d7 f6451001 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   ff5514               | call                dword ptr [ebp + 0x14]
            //   46                   | inc                 esi
            //   833cb700             | cmp                 dword ptr [edi + esi*4], 0
            //   8d04b7               | lea                 eax, [edi + esi*4]
            //   75d7                 | jne                 0xffffffd9
            //   f6451001             | test                byte ptr [ebp + 0x10], 1

        $sequence_1 = { 8d4601 85c0 741e 83c004 50 a1???????? 6a08 }
            // n = 7, score = 100
            //   8d4601               | lea                 eax, [esi + 1]
            //   85c0                 | test                eax, eax
            //   741e                 | je                  0x20
            //   83c004               | add                 eax, 4
            //   50                   | push                eax
            //   a1????????           |                     
            //   6a08                 | push                8

        $sequence_2 = { ffd7 85c0 7508 53 8d542410 52 }
            // n = 6, score = 100
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7508                 | jne                 0xa
            //   53                   | push                ebx
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   52                   | push                edx

        $sequence_3 = { 807eff00 750b 803e00 740a 03c3 3bc3 }
            // n = 6, score = 100
            //   807eff00             | cmp                 byte ptr [esi - 1], 0
            //   750b                 | jne                 0xd
            //   803e00               | cmp                 byte ptr [esi], 0
            //   740a                 | je                  0xc
            //   03c3                 | add                 eax, ebx
            //   3bc3                 | cmp                 eax, ebx

        $sequence_4 = { 88442424 8b442418 8b08 8d54241c 52 8b9792b04200 52 }
            // n = 7, score = 100
            //   88442424             | mov                 byte ptr [esp + 0x24], al
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   52                   | push                edx
            //   8b9792b04200         | mov                 edx, dword ptr [edi + 0x42b092]
            //   52                   | push                edx

        $sequence_5 = { 8d542438 52 6813000020 53 c744242404000000 c744244400000000 ff15???????? }
            // n = 7, score = 100
            //   8d542438             | lea                 edx, [esp + 0x38]
            //   52                   | push                edx
            //   6813000020           | push                0x20000013
            //   53                   | push                ebx
            //   c744242404000000     | mov                 dword ptr [esp + 0x24], 4
            //   c744244400000000     | mov                 dword ptr [esp + 0x44], 0
            //   ff15????????         |                     

        $sequence_6 = { 8b44246c 47 57 8d4c247c 8d7c241c c784248000000000100000 e8???????? }
            // n = 7, score = 100
            //   8b44246c             | mov                 eax, dword ptr [esp + 0x6c]
            //   47                   | inc                 edi
            //   57                   | push                edi
            //   8d4c247c             | lea                 ecx, [esp + 0x7c]
            //   8d7c241c             | lea                 edi, [esp + 0x1c]
            //   c784248000000000100000     | mov    dword ptr [esp + 0x80], 0x1000
            //   e8????????           |                     

        $sequence_7 = { 85ed 750f 396b08 7462 833b2c 725d }
            // n = 6, score = 100
            //   85ed                 | test                ebp, ebp
            //   750f                 | jne                 0x11
            //   396b08               | cmp                 dword ptr [ebx + 8], ebp
            //   7462                 | je                  0x64
            //   833b2c               | cmp                 dword ptr [ebx], 0x2c
            //   725d                 | jb                  0x5f

        $sequence_8 = { 51 53 55 56 8bf0 8b4648 57 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   56                   | push                esi
            //   8bf0                 | mov                 esi, eax
            //   8b4648               | mov                 eax, dword ptr [esi + 0x48]
            //   57                   | push                edi

        $sequence_9 = { ffd5 3d02010000 750d 803d????????00 0f85fbfeffff 5f 5e }
            // n = 7, score = 100
            //   ffd5                 | call                ebp
            //   3d02010000           | cmp                 eax, 0x102
            //   750d                 | jne                 0xf
            //   803d????????00       |                     
            //   0f85fbfeffff         | jne                 0xffffff01
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 421888
}