rule win_gtpdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.gtpdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.gtpdoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { fc b932000000 b800000000 f3aa }
            // n = 4, score = 200
            //   fc                   | cld                 
            //   b932000000           | mov                 ecx, 0x32
            //   b800000000           | mov                 eax, 0
            //   f3aa                 | rep stosb           byte ptr es:[edi], al

        $sequence_1 = { 0fb600 31d0 8801 8045fb01 8345fc01 }
            // n = 5, score = 200
            //   0fb600               | movzx               eax, byte ptr [eax]
            //   31d0                 | xor                 eax, edx
            //   8801                 | mov                 byte ptr [ecx], al
            //   8045fb01             | add                 byte ptr [ebp - 5], 1
            //   8345fc01             | add                 dword ptr [ebp - 4], 1

        $sequence_2 = { e8???????? 8945c8 837dc8ff 7528 e8???????? 8b38 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8945c8               | push                ebp
            //   837dc8ff             | dec                 eax
            //   7528                 | mov                 ebp, esp
            //   e8????????           |                     
            //   8b38                 | je                  0x1b
            //   e8????????           |                     

        $sequence_3 = { 8945f4 8d950afaffff b8dc050000 89442408 c744240400000000 891424 e8???????? }
            // n = 7, score = 100
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8d950afaffff         | lea                 edx, [ebp - 0x5f6]
            //   b8dc050000           | mov                 eax, 0x5dc
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   891424               | mov                 dword ptr [esp], edx
            //   e8????????           |                     

        $sequence_4 = { fc 488bbda0f1ffff f2ae 4889c8 48f7d0 }
            // n = 5, score = 100
            //   fc                   | mov                 dword ptr [ebp - 0x38], eax
            //   488bbda0f1ffff       | cmp                 dword ptr [ebp - 0x38], -1
            //   f2ae                 | jne                 0x2e
            //   4889c8               | mov                 edi, dword ptr [eax]
            //   48f7d0               | dec                 esp

        $sequence_5 = { 55 48833d????????00 4889e5 7416 b800000000 4885c0 740c }
            // n = 7, score = 100
            //   55                   | dec                 eax
            //   48833d????????00     |                     
            //   4889e5               | mov                 dword ptr [ebp - 0x18], edi
            //   7416                 | dec                 eax
            //   b800000000           | mov                 dword ptr [ebp - 0x28], edx
            //   4885c0               | dec                 esp
            //   740c                 | mov                 dword ptr [ebp - 0x38], eax

        $sequence_6 = { a3???????? a1???????? c744240800000000 c744240400000000 890424 }
            // n = 5, score = 100
            //   a3????????           |                     
            //   a1????????           |                     
            //   c744240800000000     | mov                 dword ptr [esp + 8], 0
            //   c744240400000000     | mov                 dword ptr [esp + 4], 0
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_7 = { 0fb64009 3c01 757b 8b45e8 83c00c }
            // n = 5, score = 100
            //   0fb64009             | movzx               eax, byte ptr [eax + 9]
            //   3c01                 | cmp                 al, 1
            //   757b                 | jne                 0x7d
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   83c00c               | add                 eax, 0xc

        $sequence_8 = { f7d0 8d50ff 8b45e8 83c00c bf???????? }
            // n = 5, score = 100
            //   f7d0                 | not                 eax
            //   8d50ff               | lea                 edx, [eax - 1]
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   83c00c               | add                 eax, 0xc
            //   bf????????           |                     

        $sequence_9 = { c9 c3 55 4889e5 48897de8 488955d8 4c8945c8 }
            // n = 7, score = 100
            //   c9                   | movzx               eax, byte ptr [ebp - 1]
            //   c3                   | mov                 byte ptr [edx], al
            //   55                   | leave               
            //   4889e5               | ret                 
            //   48897de8             | push                ebp
            //   488955d8             | dec                 eax
            //   4c8945c8             | mov                 ebp, esp

        $sequence_10 = { 8b7dd4 f2ae 89c8 f7d0 83e801 83c001 }
            // n = 6, score = 100
            //   8b7dd4               | mov                 edi, dword ptr [ebp - 0x2c]
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   89c8                 | mov                 eax, ecx
            //   f7d0                 | not                 eax
            //   83e801               | sub                 eax, 1
            //   83c001               | add                 eax, 1

        $sequence_11 = { 8b450c 8945ea c645ee00 0fb68504faffff }
            // n = 4, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8945ea               | mov                 dword ptr [ebp - 0x16], eax
            //   c645ee00             | mov                 byte ptr [ebp - 0x12], 0
            //   0fb68504faffff       | movzx               eax, byte ptr [ebp - 0x5fc]

        $sequence_12 = { 4c89c9 e8???????? 8945fc 8b75fc bf???????? b800000000 }
            // n = 6, score = 100
            //   4c89c9               | mov                 eax, 0
            //   e8????????           |                     
            //   8945fc               | dec                 eax
            //   8b75fc               | test                eax, eax
            //   bf????????           |                     
            //   b800000000           | je                  0x1b

        $sequence_13 = { 4889c2 480355e0 0fb645ff 8802 }
            // n = 4, score = 100
            //   4889c2               | dec                 eax
            //   480355e0             | mov                 edx, eax
            //   0fb645ff             | dec                 eax
            //   8802                 | add                 edx, dword ptr [ebp - 0x20]

    condition:
        7 of them and filesize < 4210688
}