rule win_hackbrowserdata_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hackbrowserdata."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hackbrowserdata"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb14 488b8c2458010000 488b5150 e8???????? 498913 48c7415000000000 488b842410010000 }
            // n = 7, score = 100
            //   eb14                 | mov                 dword ptr [esp + 0x60], edx
            //   488b8c2458010000     | dec                 eax
            //   488b5150             | lea                 edx, [0x6dc152]
            //   e8????????           |                     
            //   498913               | inc                 esp
            //   48c7415000000000     | movups              xmmword ptr [esp + 0x280], xmm7
            //   488b842410010000     | inc                 esp

        $sequence_1 = { c3 4989f0 4d8b4008 4883c610 48ffc0 4a8d0c01 488d4901 }
            // n = 7, score = 100
            //   c3                   | dec                 eax
            //   4989f0               | mov                 dword ptr [esp + 0xa8], edx
            //   4d8b4008             | dec                 eax
            //   4883c610             | mov                 eax, dword ptr [edx]
            //   48ffc0               | dec                 eax
            //   4a8d0c01             | mov                 dword ptr [esp + 0x90], eax
            //   488d4901             | dec                 eax

        $sequence_2 = { eb22 488d1568e79f00 488b5c2470 488b442468 488b8c24a8000000 488d354f6ba000 31d2 }
            // n = 7, score = 100
            //   eb22                 | dec                 eax
            //   488d1568e79f00       | mov                 eax, dword ptr [esp + 0x4f0]
            //   488b5c2470           | dec                 eax
            //   488b442468           | mov                 ebx, dword ptr [esp + 0x4f8]
            //   488b8c24a8000000     | call                ecx
            //   488d354f6ba000       | dec                 eax
            //   31d2                 | mov                 dword ptr [esp + 0x1c8], ebx

        $sequence_3 = { 884c2446 e8???????? 48898c24e8000000 4889bc24f0000000 4885c9 7459 0fb64c2447 }
            // n = 7, score = 100
            //   884c2446             | test                edi, edi
            //   e8????????           |                     
            //   48898c24e8000000     | jne                 0xd09
            //   4889bc24f0000000     | dec                 eax
            //   4885c9               | lea                 ecx, [ebx + 0x78]
            //   7459                 | not                 eax
            //   0fb64c2447           | and                 dword ptr [ecx], eax

        $sequence_4 = { eb17 e8???????? 488bb42458010000 498933 4c8b00 4d894308 488930 }
            // n = 7, score = 100
            //   eb17                 | mov                 edx, ecx
            //   e8????????           |                     
            //   488bb42458010000     | dec                 eax
            //   498933               | mov                 edx, dword ptr [edx + 0x70]
            //   4c8b00               | nop                 
            //   4d894308             | dec                 eax
            //   488930               | add                 esp, 0x48

        $sequence_5 = { e8???????? 488d0551f2d100 bb32000000 e8???????? 90 4889442408 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d0551f2d100       | dec                 eax
            //   bb32000000           | mov                 dword ptr [edx], eax
            //   e8????????           |                     
            //   90                   | mov                 edx, dword ptr [esp + 0xa8]
            //   4889442408           | test                edx, edx
            //   e8????????           |                     

        $sequence_6 = { e8???????? 488b9c2480000000 49891b 488b340a 49897308 48891c0a 488d0589e51a00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b9c2480000000     | mov                 eax, dword ptr [esi]
            //   49891b               | dec                 eax
            //   488b340a             | test                eax, eax
            //   49897308             | dec                 eax
            //   48891c0a             | mov                 edx, dword ptr [esp + 0x40]
            //   488d0589e51a00       | dec                 eax

        $sequence_7 = { f00fc15848 ffcb 85db 7d10 4c89c0 e8???????? 488b842408010000 }
            // n = 7, score = 100
            //   f00fc15848           | pop                 ebp
            //   ffcb                 | ret                 
            //   85db                 | dec                 eax
            //   7d10                 | mov                 esi, dword ptr [eax + ecx*8 + 0x420]
            //   4c89c0               | dec                 eax
            //   e8????????           |                     
            //   488b842408010000     | test                esi, esi

        $sequence_8 = { c6461506 4889ca 90 83793000 742d 488d0d44bc7d00 48894c2478 }
            // n = 7, score = 100
            //   c6461506             | cmp                 eax, 0x7c
            //   4889ca               | jae                 0x9b1
            //   90                   | dec                 eax
            //   83793000             | lea                 ecx, [edx + eax*4]
            //   742d                 | dec                 eax
            //   488d0d44bc7d00       | mov                 ebx, ecx
            //   48894c2478           | ret                 

        $sequence_9 = { e8???????? 0f1f440000 83f803 750d 8b9424c0000000 85d2 7509 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0f1f440000           | mov                 eax, ecx
            //   83f803               | xor                 ecx, ecx
            //   750d                 | dec                 eax
            //   8b9424c0000000       | mov                 ebx, dword ptr [esp + 0x40]
            //   85d2                 | mov                 byte ptr [esp + 0x37], 1
            //   7509                 | dec                 eax

    condition:
        7 of them and filesize < 42451968
}