rule win_hakbit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hakbit"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 40 c1e004 8b4dfc 8d740104 8b45e4 c1e004 8b4dfc }
            // n = 7, score = 300
            //   40                   | inc                 eax
            //   c1e004               | shl                 eax, 4
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8d740104             | lea                 esi, [ecx + eax + 4]
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   c1e004               | shl                 eax, 4
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_1 = { 8bec 51 51 c745f8010000c0 e8???????? 58 }
            // n = 6, score = 300
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   51                   | push                ecx
            //   c745f8010000c0       | mov                 dword ptr [ebp - 8], 0xc0000001
            //   e8????????           |                     
            //   58                   | pop                 eax

        $sequence_2 = { 40 8945f4 837df403 7377 8b45f4 8b4dfc }
            // n = 6, score = 300
            //   40                   | inc                 eax
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   837df403             | cmp                 dword ptr [ebp - 0xc], 3
            //   7377                 | jae                 0x79
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_3 = { ff7508 8b45fc 83c018 ffd0 8945f8 837df800 0f8ca8000000 }
            // n = 7, score = 300
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   83c018               | add                 eax, 0x18
            //   ffd0                 | call                eax
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   0f8ca8000000         | jl                  0xae

        $sequence_4 = { 8b4dfc 8b44810c 2b450c 8945f0 8365ec00 eb07 8b45ec }
            // n = 7, score = 300
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b44810c             | mov                 eax, dword ptr [ecx + eax*4 + 0xc]
            //   2b450c               | sub                 eax, dword ptr [ebp + 0xc]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   8365ec00             | and                 dword ptr [ebp - 0x14], 0
            //   eb07                 | jmp                 9
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_5 = { 88040a ebd2 e9???????? 8b45f8 5e c9 c21400 }
            // n = 7, score = 300
            //   88040a               | mov                 byte ptr [edx + ecx], al
            //   ebd2                 | jmp                 0xffffffd4
            //   e9????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c21400               | ret                 0x14

        $sequence_6 = { 8364010c00 8b45e8 c1e004 8b4dfc c644010800 8b45e8 c1e004 }
            // n = 7, score = 300
            //   8364010c00           | and                 dword ptr [ecx + eax + 0xc], 0
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   c1e004               | shl                 eax, 4
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   c644010800           | mov                 byte ptr [ecx + eax + 8], 0
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   c1e004               | shl                 eax, 4

        $sequence_7 = { 51 c745f8010000c0 e8???????? 58 2500f0ffff 8945fc 837d1400 }
            // n = 7, score = 300
            //   51                   | push                ecx
            //   c745f8010000c0       | mov                 dword ptr [ebp - 8], 0xc0000001
            //   e8????????           |                     
            //   58                   | pop                 eax
            //   2500f0ffff           | and                 eax, 0xfffff000
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837d1400             | cmp                 dword ptr [ebp + 0x14], 0

        $sequence_8 = { 33c9 8b55fc 66894c020a 8b45e8 c1e004 8b4dfc 8364010c00 }
            // n = 7, score = 300
            //   33c9                 | xor                 ecx, ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   66894c020a           | mov                 word ptr [edx + eax + 0xa], cx
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   c1e004               | shl                 eax, 4
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8364010c00           | and                 dword ptr [ecx + eax + 0xc], 0

        $sequence_9 = { 0f8ca8000000 ff7508 8b45fc ff10 }
            // n = 4, score = 300
            //   0f8ca8000000         | jl                  0xae
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   ff10                 | call                dword ptr [eax]

    condition:
        7 of them and filesize < 656384
}