rule win_halfrig_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.halfrig."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.halfrig"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 403835???????? 4c8d0d37670400 7439 488bd7 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   403835????????       |                     
            //   4c8d0d37670400       | dec                 eax
            //   7439                 | lea                 ecx, [ecx + 0x80]
            //   488bd7               | movups              xmm0, xmmword ptr [eax]

        $sequence_1 = { 488d0d03d10600 e8???????? 833d????????ff 0f858a000000 488d542420 4c8bc6 }
            // n = 6, score = 100
            //   488d0d03d10600       | movzx               eax, byte ptr [eax]
            //   e8????????           |                     
            //   833d????????ff       |                     
            //   0f858a000000         | dec                 esp
            //   488d542420           | lea                 edi, [0x67753]
            //   4c8bc6               | mov                 byte ptr [ecx], al

        $sequence_2 = { 488d0d9c6a0700 e8???????? 40383d???????? 7435 488bd3 4c8bc7 43301438 }
            // n = 7, score = 100
            //   488d0d9c6a0700       | jb                  0x5f9
            //   e8????????           |                     
            //   40383d????????       |                     
            //   7435                 | mov                 eax, dword ptr [edi]
            //   488bd3               | dec                 esp
            //   4c8bc7               | mov                 dword ptr [esi + 0x108], ecx
            //   43301438             | dec                 ecx

        $sequence_3 = { 49ffc0 4833d0 4983f807 72db 40883d???????? 418b06 4c894e20 }
            // n = 7, score = 100
            //   49ffc0               | dec                 esp
            //   4833d0               | lea                 edi, [0x6d273]
            //   4983f807             | mov                 byte ptr [ecx], al
            //   72db                 | inc                 ecx
            //   40883d????????       |                     
            //   418b06               | mov                 eax, dword ptr [esi]
            //   4c894e20             | jle                 0x23c

        $sequence_4 = { 8802 488d542420 e8???????? 488d0d5cc00700 e8???????? 40383d???????? }
            // n = 6, score = 100
            //   8802                 | mov                 byte ptr [ecx], al
            //   488d542420           | inc                 ecx
            //   e8????????           |                     
            //   488d0d5cc00700       | mov                 eax, dword ptr [esi]
            //   e8????????           |                     
            //   40383d????????       |                     

        $sequence_5 = { e8???????? 488d0d20da0500 e8???????? 40383d???????? 7435 488bd3 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   488d0d20da0500       | lea                 ecx, [0x49ea8]
            //   e8????????           |                     
            //   40383d????????       |                     
            //   7435                 | jne                 0x126a
            //   488bd3               | jle                 0x1281

        $sequence_6 = { 48c1e008 488bd1 49ffc0 4833d0 4983f80c 72db 40883d???????? }
            // n = 7, score = 100
            //   48c1e008             | mov                 dword ptr [esi + 0x20], ecx
            //   488bd1               | jle                 0x1cf5
            //   49ffc0               | dec                 eax
            //   4833d0               | lea                 ecx, [0x48dce]
            //   4983f80c             | dec                 esp
            //   72db                 | mov                 dword ptr [esi + 0x20], ecx
            //   40883d????????       |                     

        $sequence_7 = { 0f1149f0 4883ea01 75ad 0fb600 4c8d3d43ee0600 }
            // n = 5, score = 100
            //   0f1149f0             | lea                 eax, [0x4aa7c]
            //   4883ea01             | dec                 eax
            //   75ad                 | mov                 edx, esi
            //   0fb600               | dec                 eax
            //   4c8d3d43ee0600       | lea                 ecx, [ebp + 0x330]

        $sequence_8 = { 8801 418b06 3905???????? 0f8ea3000000 488d0da7b30500 }
            // n = 5, score = 100
            //   8801                 | sub                 edx, 1
            //   418b06               | jne                 0xdc1
            //   3905????????         |                     
            //   0f8ea3000000         | movzx               eax, byte ptr [eax]
            //   488d0da7b30500       | dec                 esp

        $sequence_9 = { 40883d???????? 4c893d???????? 488d8d30030000 488d059c5a0200 488bd6 660f1f840000000000 488d8980000000 }
            // n = 7, score = 100
            //   40883d????????       |                     
            //   4c893d????????       |                     
            //   488d8d30030000       | mov                 edx, esi
            //   488d059c5a0200       | nop                 word ptr [eax + eax]
            //   488bd6               | dec                 eax
            //   660f1f840000000000     | lea    ecx, [ecx + 0x80]
            //   488d8980000000       | movups              xmm0, xmmword ptr [eax]

    condition:
        7 of them and filesize < 1369088
}