rule win_hazy_load_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hazy_load."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hazy_load"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 418bcc 448d4205 ff15???????? 488bd8 }
            // n = 4, score = 200
            //   418bcc               | dec                 eax
            //   448d4205             | lea                 ecx, [0x16a38]
            //   ff15????????         |                     
            //   488bd8               | cmp                 byte ptr [ecx + 1], al

        $sequence_1 = { 488d0d70e70000 f6413820 74b7 33d2 418bc9 448d4202 }
            // n = 6, score = 200
            //   488d0d70e70000       | inc                 esp
            //   f6413820             | cmova               ebp, eax
            //   74b7                 | inc                 esp
            //   33d2                 | mov                 dword ptr [esp + 0x48], ebp
            //   418bc9               | inc                 ecx
            //   448d4202             | lea                 eax, [ebp - 1]

        $sequence_2 = { 418d4102 83f801 761e 498bc9 488d153bfb0000 83e13f 498bc1 }
            // n = 7, score = 200
            //   418d4102             | mov                 esi, dword ptr [esp + 0x50]
            //   83f801               | add                 ebx, eax
            //   761e                 | cmp                 ebx, 2
            //   498bc9               | jl                  0x5f
            //   488d153bfb0000       | cmp                 ebx, 2
            //   83e13f               | sete                al
            //   498bc1               | dec                 eax

        $sequence_3 = { 4c8d05e3f8ffff 4889442428 4533c9 33d2 89442420 }
            // n = 5, score = 200
            //   4c8d05e3f8ffff       | test                eax, eax
            //   4889442428           | jle                 0x30
            //   4533c9               | inc                 esp
            //   33d2                 | lea                 ecx, [eax + 4]
            //   89442420             | dec                 eax

        $sequence_4 = { 488d1588f4feff c1e803 89442448 448be0 89442440 85c0 0f84d3030000 }
            // n = 7, score = 200
            //   488d1588f4feff       | dec                 ecx
            //   c1e803               | mov                 eax, edx
            //   89442448             | inc                 ecx
            //   448be0               | mov                 ebp, ecx
            //   89442440             | dec                 eax
            //   85c0                 | sar                 eax, 6
            //   0f84d3030000         | dec                 eax

        $sequence_5 = { 483b0d???????? 7417 488d0570630100 483bc8 740b 83791000 7505 }
            // n = 7, score = 200
            //   483b0d????????       |                     
            //   7417                 | nop                 dword ptr [eax]
            //   488d0570630100       | inc                 edx
            //   483bc8               | movzx               eax, byte ptr [ebx + eax]
            //   740b                 | inc                 edx
            //   83791000             | mov                 byte ptr [ecx + eax], al
            //   7505                 | sete                al

        $sequence_6 = { 488d0d386a0100 488bc3 83e33f 48c1f806 48c1e306 }
            // n = 5, score = 200
            //   488d0d386a0100       | dec                 eax
            //   488bc3               | mov                 ebp, edx
            //   83e33f               | dec                 esp
            //   48c1f806             | lea                 ecx, [0x11d27]
            //   48c1e306             | dec                 eax

        $sequence_7 = { ff15???????? 41b810000000 488d542420 488bcb }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   41b810000000         | and                 dword ptr [edi + 0x50], 0
            //   488d542420           | dec                 eax
            //   488bcb               | lea                 eax, [0xffffe0ad]

        $sequence_8 = { 4883ec20 488d3d93690100 48393d???????? 742b }
            // n = 4, score = 200
            //   4883ec20             | lea                 ecx, [0x1c092]
            //   488d3d93690100       | inc                 ebp
            //   48393d????????       |                     
            //   742b                 | xor                 eax, eax

        $sequence_9 = { eb12 488d0d46fe0000 c7435006000000 48894b48 c6435400 }
            // n = 5, score = 200
            //   eb12                 | mov                 dword ptr [edi + 4], esi
            //   488d0d46fe0000       | dec                 eax
            //   c7435006000000       | mov                 edx, ebp
            //   48894b48             | dec                 esp
            //   c6435400             | mov                 eax, edi

    condition:
        7 of them and filesize < 315392
}