rule win_hdmr_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hdmr."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hdmr"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4514 8b16 8b527c 50 57 }
            // n = 5, score = 100
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8b527c               | mov                 edx, dword ptr [edx + 0x7c]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_1 = { 7511 8b4d0c 8b5018 51 8bce }
            // n = 5, score = 100
            //   7511                 | jne                 0x13
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b5018               | mov                 edx, dword ptr [eax + 0x18]
            //   51                   | push                ecx
            //   8bce                 | mov                 ecx, esi

        $sequence_2 = { 8b048540d04100 83e61f c1e606 59 c644300400 85ff }
            // n = 6, score = 100
            //   8b048540d04100       | mov                 eax, dword ptr [eax*4 + 0x41d040]
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   59                   | pop                 ecx
            //   c644300400           | mov                 byte ptr [eax + esi + 4], 0
            //   85ff                 | test                edi, edi

        $sequence_3 = { 83c40c 33f6 e8???????? 25ff000080 7907 48 0d00ffffff }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   33f6                 | xor                 esi, esi
            //   e8????????           |                     
            //   25ff000080           | and                 eax, 0x800000ff
            //   7907                 | jns                 9
            //   48                   | dec                 eax
            //   0d00ffffff           | or                  eax, 0xffffff00

        $sequence_4 = { be00000000 7454 f6c301 7445 8d8df0f5ffff }
            // n = 5, score = 100
            //   be00000000           | mov                 esi, 0
            //   7454                 | je                  0x56
            //   f6c301               | test                bl, 1
            //   7445                 | je                  0x47
            //   8d8df0f5ffff         | lea                 ecx, [ebp - 0xa10]

        $sequence_5 = { 0f84e1030000 6a00 6a00 6a00 }
            // n = 4, score = 100
            //   0f84e1030000         | je                  0x3e7
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_6 = { 5e 8bc8 8b929c000000 5d }
            // n = 4, score = 100
            //   5e                   | pop                 esi
            //   8bc8                 | mov                 ecx, eax
            //   8b929c000000         | mov                 edx, dword ptr [edx + 0x9c]
            //   5d                   | pop                 ebp

        $sequence_7 = { 53 ff15???????? 85c0 7451 57 e8???????? 83c404 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7451                 | je                  0x53
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_8 = { 33cb 33480c 8bdf c1eb08 894df0 8b4d08 81e3ff000000 }
            // n = 7, score = 100
            //   33cb                 | xor                 ecx, ebx
            //   33480c               | xor                 ecx, dword ptr [eax + 0xc]
            //   8bdf                 | mov                 ebx, edi
            //   c1eb08               | shr                 ebx, 8
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   81e3ff000000         | and                 ebx, 0xff

        $sequence_9 = { 33c0 68fe070000 50 8d8c2472020000 51 8974241c 6689842474020000 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   68fe070000           | push                0x7fe
            //   50                   | push                eax
            //   8d8c2472020000       | lea                 ecx, [esp + 0x272]
            //   51                   | push                ecx
            //   8974241c             | mov                 dword ptr [esp + 0x1c], esi
            //   6689842474020000     | mov                 word ptr [esp + 0x274], ax

    condition:
        7 of them and filesize < 284672
}