rule win_headertip_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.headertip."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.headertip"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 e8???????? 83c40c ff7510 03f7 ffd6 85c0 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   03f7                 | add                 esi, edi
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax

        $sequence_1 = { e8???????? eb2e ff75fc 53 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   eb2e                 | jmp                 0x30
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   53                   | push                ebx

        $sequence_2 = { 68???????? 50 ff15???????? 83c410 85c0 750d }
            // n = 6, score = 100
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   750d                 | jne                 0xf

        $sequence_3 = { 83c40c 85ff 751c ff35???????? ff15???????? }
            // n = 5, score = 100
            //   83c40c               | add                 esp, 0xc
            //   85ff                 | test                edi, edi
            //   751c                 | jne                 0x1e
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_4 = { 33c9 66894802 c3 53 }
            // n = 4, score = 100
            //   33c9                 | xor                 ecx, ecx
            //   66894802             | mov                 word ptr [eax + 2], cx
            //   c3                   | ret                 
            //   53                   | push                ebx

        $sequence_5 = { 03cb 894df8 eb3e 8b4018 }
            // n = 4, score = 100
            //   03cb                 | add                 ecx, ebx
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   eb3e                 | jmp                 0x40
            //   8b4018               | mov                 eax, dword ptr [eax + 0x18]

        $sequence_6 = { 885d10 c6452448 c6452574 c6452674 c6452770 c6452851 }
            // n = 6, score = 100
            //   885d10               | mov                 byte ptr [ebp + 0x10], bl
            //   c6452448             | mov                 byte ptr [ebp + 0x24], 0x48
            //   c6452574             | mov                 byte ptr [ebp + 0x25], 0x74
            //   c6452674             | mov                 byte ptr [ebp + 0x26], 0x74
            //   c6452770             | mov                 byte ptr [ebp + 0x27], 0x70
            //   c6452851             | mov                 byte ptr [ebp + 0x28], 0x51

        $sequence_7 = { 50 ff35???????? ff15???????? a3???????? 8d45b0 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   a3????????           |                     
            //   8d45b0               | lea                 eax, [ebp - 0x50]

        $sequence_8 = { ff35???????? c745fc80330000 ff15???????? 53 8d45fc 50 }
            // n = 6, score = 100
            //   ff35????????         |                     
            //   c745fc80330000       | mov                 dword ptr [ebp - 4], 0x3380
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax

        $sequence_9 = { 8b4114 2b410c 03c6 ebea 56 }
            // n = 5, score = 100
            //   8b4114               | mov                 eax, dword ptr [ecx + 0x14]
            //   2b410c               | sub                 eax, dword ptr [ecx + 0xc]
            //   03c6                 | add                 eax, esi
            //   ebea                 | jmp                 0xffffffec
            //   56                   | push                esi

    condition:
        7 of them and filesize < 174080
}