rule win_heloag_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.heloag."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.heloag"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c9ff bf???????? 33c0 8965f0 f2ae f7d1 }
            // n = 6, score = 300
            //   83c9ff               | or                  ecx, 0xffffffff
            //   bf????????           |                     
            //   33c0                 | xor                 eax, eax
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx

        $sequence_1 = { 8945e4 85db 0f847b020000 8bfb 83c9ff 33c0 }
            // n = 6, score = 300
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   85db                 | test                ebx, ebx
            //   0f847b020000         | je                  0x281
            //   8bfb                 | mov                 edi, ebx
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 8bf7 8bfa 8d95dcfeffff c1e902 f3a5 }
            // n = 5, score = 300
            //   8bf7                 | mov                 esi, edi
            //   8bfa                 | mov                 edi, edx
            //   8d95dcfeffff         | lea                 edx, [ebp - 0x124]
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_3 = { 64892500000000 81ec48030000 53 56 }
            // n = 4, score = 300
            //   64892500000000       | mov                 dword ptr fs:[0], esp
            //   81ec48030000         | sub                 esp, 0x348
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_4 = { 33c0 bf???????? 881d???????? f3ab 8b4df4 64890d00000000 5f }
            // n = 7, score = 300
            //   33c0                 | xor                 eax, eax
            //   bf????????           |                     
            //   881d????????         |                     
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   5f                   | pop                 edi

        $sequence_5 = { 7577 56 ff15???????? 85c0 7507 }
            // n = 5, score = 300
            //   7577                 | jne                 0x79
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9

        $sequence_6 = { b907000000 bf???????? c605????????01 50 f3a5 }
            // n = 5, score = 300
            //   b907000000           | mov                 ecx, 7
            //   bf????????           |                     
            //   c605????????01       |                     
            //   50                   | push                eax
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_7 = { 8bca 53 83e103 53 f3a4 a1???????? }
            // n = 6, score = 300
            //   8bca                 | mov                 ecx, edx
            //   53                   | push                ebx
            //   83e103               | and                 ecx, 3
            //   53                   | push                ebx
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   a1????????           |                     

        $sequence_8 = { 49 51 56 68???????? }
            // n = 4, score = 200
            //   49                   | dec                 ecx
            //   51                   | push                ecx
            //   56                   | push                esi
            //   68????????           |                     

        $sequence_9 = { a1???????? 894304 8b5608 895308 }
            // n = 4, score = 200
            //   a1????????           |                     
            //   894304               | mov                 dword ptr [ebx + 4], eax
            //   8b5608               | mov                 edx, dword ptr [esi + 8]
            //   895308               | mov                 dword ptr [ebx + 8], edx

        $sequence_10 = { 8a442413 6a00 8bce 8806 ff15???????? }
            // n = 5, score = 200
            //   8a442413             | mov                 al, byte ptr [esp + 0x13]
            //   6a00                 | push                0
            //   8bce                 | mov                 ecx, esi
            //   8806                 | mov                 byte ptr [esi], al
            //   ff15????????         |                     

        $sequence_11 = { 84c0 742d 8b7604 85f6 7506 8b35???????? 8b7b04 }
            // n = 7, score = 200
            //   84c0                 | test                al, al
            //   742d                 | je                  0x2f
            //   8b7604               | mov                 esi, dword ptr [esi + 4]
            //   85f6                 | test                esi, esi
            //   7506                 | jne                 8
            //   8b35????????         |                     
            //   8b7b04               | mov                 edi, dword ptr [ebx + 4]

        $sequence_12 = { 8b11 8bcf 52 6a00 50 }
            // n = 5, score = 200
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8bcf                 | mov                 ecx, edi
            //   52                   | push                edx
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_13 = { 53 8bcd ff15???????? 6a00 6a00 }
            // n = 5, score = 200
            //   53                   | push                ebx
            //   8bcd                 | mov                 ecx, ebp
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_14 = { 894b0c 8a48ff fec1 8848ff eb3c 6a01 }
            // n = 6, score = 200
            //   894b0c               | mov                 dword ptr [ebx + 0xc], ecx
            //   8a48ff               | mov                 cl, byte ptr [eax - 1]
            //   fec1                 | inc                 cl
            //   8848ff               | mov                 byte ptr [eax - 1], cl
            //   eb3c                 | jmp                 0x3e
            //   6a01                 | push                1

        $sequence_15 = { 3bcd 8b07 89442410 7464 }
            // n = 4, score = 200
            //   3bcd                 | cmp                 ecx, ebp
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   7464                 | je                  0x66

    condition:
        7 of them and filesize < 401408
}