rule win_hermeticwizard_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hermeticwizard."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hermeticwizard"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8a87c0d10110 08441619 42 0fb64101 3bd0 }
            // n = 5, score = 100
            //   8a87c0d10110         | mov                 al, byte ptr [edi + 0x1001d1c0]
            //   08441619             | or                  byte ptr [esi + edx + 0x19], al
            //   42                   | inc                 edx
            //   0fb64101             | movzx               eax, byte ptr [ecx + 1]
            //   3bd0                 | cmp                 edx, eax

        $sequence_1 = { 33c0 eb11 ff37 ff15???????? 50 ff37 ff15???????? }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   eb11                 | jmp                 0x13
            //   ff37                 | push                dword ptr [edi]
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff37                 | push                dword ptr [edi]
            //   ff15????????         |                     

        $sequence_2 = { 75e7 8b4d08 8d45e4 50 e8???????? 3b30 }
            // n = 6, score = 100
            //   75e7                 | jne                 0xffffffe9
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   3b30                 | cmp                 esi, dword ptr [eax]

        $sequence_3 = { 8bec 83ec14 56 8bf1 837e0400 }
            // n = 5, score = 100
            //   8bec                 | mov                 ebp, esp
            //   83ec14               | sub                 esp, 0x14
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   837e0400             | cmp                 dword ptr [esi + 4], 0

        $sequence_4 = { 85c0 0f95c2 85c0 74dd }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   0f95c2               | setne               dl
            //   85c0                 | test                eax, eax
            //   74dd                 | je                  0xffffffdf

        $sequence_5 = { 5d c3 55 8bec 3bca 7452 56 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   3bca                 | cmp                 ecx, edx
            //   7452                 | je                  0x54
            //   56                   | push                esi

        $sequence_6 = { 8bcb 52 ff33 e8???????? 8b5508 8b12 895508 }
            // n = 7, score = 100
            //   8bcb                 | mov                 ecx, ebx
            //   52                   | push                edx
            //   ff33                 | push                dword ptr [ebx]
            //   e8????????           |                     
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8b12                 | mov                 edx, dword ptr [edx]
            //   895508               | mov                 dword ptr [ebp + 8], edx

        $sequence_7 = { 7410 68???????? 8bce e8???????? 59 894304 }
            // n = 6, score = 100
            //   7410                 | je                  0x12
            //   68????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   894304               | mov                 dword ptr [ebx + 4], eax

        $sequence_8 = { 66898d76ffffff 59 6a20 66898d78ffffff }
            // n = 4, score = 100
            //   66898d76ffffff       | mov                 word ptr [ebp - 0x8a], cx
            //   59                   | pop                 ecx
            //   6a20                 | push                0x20
            //   66898d78ffffff       | mov                 word ptr [ebp - 0x88], cx

        $sequence_9 = { 50 8d4dac e8???????? 8b4dc4 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8d4dac               | lea                 ecx, [ebp - 0x54]
            //   e8????????           |                     
            //   8b4dc4               | mov                 ecx, dword ptr [ebp - 0x3c]

    condition:
        7 of them and filesize < 263168
}