rule win_hi_zor_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.hi_zor_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hi_zor_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8b40010000 57 8d55f0 52 8d8594f6ffff 50 }
            // n = 6, score = 200
            //   8b8b40010000         | mov                 ecx, dword ptr [ebx + 0x140]
            //   57                   | push                edi
            //   8d55f0               | lea                 edx, [ebp - 0x10]
            //   52                   | push                edx
            //   8d8594f6ffff         | lea                 eax, [ebp - 0x96c]
            //   50                   | push                eax

        $sequence_1 = { 8945f8 8945fc ff15???????? 33c9 83c404 }
            // n = 5, score = 200
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   ff15????????         |                     
            //   33c9                 | xor                 ecx, ecx
            //   83c404               | add                 esp, 4

        $sequence_2 = { 8b7818 03705c c1e30e 8db43e515a5e26 }
            // n = 4, score = 200
            //   8b7818               | mov                 edi, dword ptr [eax + 0x18]
            //   03705c               | add                 esi, dword ptr [eax + 0x5c]
            //   c1e30e               | shl                 ebx, 0xe
            //   8db43e515a5e26       | lea                 esi, [esi + edi + 0x265e5a51]

        $sequence_3 = { 897df8 0b75f8 0bdf 337014 335814 03f2 }
            // n = 6, score = 200
            //   897df8               | mov                 dword ptr [ebp - 8], edi
            //   0b75f8               | or                  esi, dword ptr [ebp - 8]
            //   0bdf                 | or                  ebx, edi
            //   337014               | xor                 esi, dword ptr [eax + 0x14]
            //   335814               | xor                 ebx, dword ptr [eax + 0x14]
            //   03f2                 | add                 esi, edx

        $sequence_4 = { 23df 0bde 03585c 8975fc 8b7018 }
            // n = 5, score = 200
            //   23df                 | and                 ebx, edi
            //   0bde                 | or                  ebx, esi
            //   03585c               | add                 ebx, dword ptr [eax + 0x5c]
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   8b7018               | mov                 esi, dword ptr [eax + 0x18]

        $sequence_5 = { f3a5 66a5 682c010000 8d4320 }
            // n = 4, score = 200
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   682c010000           | push                0x12c
            //   8d4320               | lea                 eax, [ebx + 0x20]

        $sequence_6 = { 8d45fc 50 6a06 68???????? 52 c745fc00000000 ff15???????? }
            // n = 7, score = 200
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   6a06                 | push                6
            //   68????????           |                     
            //   52                   | push                edx
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   ff15????????         |                     

        $sequence_7 = { 33c0 6683b44568ffffff0d 40 83f844 }
            // n = 4, score = 200
            //   33c0                 | xor                 eax, eax
            //   6683b44568ffffff0d     | xor    word ptr [ebp + eax*2 - 0x98], 0xd
            //   40                   | inc                 eax
            //   83f844               | cmp                 eax, 0x44

        $sequence_8 = { 81c756b7c7e8 c1ef14 c1e30c 0bdf 897010 03f3 }
            // n = 6, score = 200
            //   81c756b7c7e8         | add                 edi, 0xe8c7b756
            //   c1ef14               | shr                 edi, 0x14
            //   c1e30c               | shl                 ebx, 0xc
            //   0bdf                 | or                  ebx, edi
            //   897010               | mov                 dword ptr [eax + 0x10], esi
            //   03f3                 | add                 esi, ebx

        $sequence_9 = { c7458424003300 c7458838002200 c7458c00003300 c7459024002500 c745943f003900 c7459838000a00 c7459c04002300 }
            // n = 7, score = 200
            //   c7458424003300       | mov                 dword ptr [ebp - 0x7c], 0x330024
            //   c7458838002200       | mov                 dword ptr [ebp - 0x78], 0x220038
            //   c7458c00003300       | mov                 dword ptr [ebp - 0x74], 0x330000
            //   c7459024002500       | mov                 dword ptr [ebp - 0x70], 0x250024
            //   c745943f003900       | mov                 dword ptr [ebp - 0x6c], 0x39003f
            //   c7459838000a00       | mov                 dword ptr [ebp - 0x68], 0xa0038
            //   c7459c04002300       | mov                 dword ptr [ebp - 0x64], 0x230004

    condition:
        7 of them and filesize < 73728
}