rule win_htbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.htbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.htbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c6f0 3bc6 7448 837e0c00 8d7e0c 7c2c 8b10 }
            // n = 7, score = 100
            //   83c6f0               | add                 esi, -0x10
            //   3bc6                 | cmp                 eax, esi
            //   7448                 | je                  0x4a
            //   837e0c00             | cmp                 dword ptr [esi + 0xc], 0
            //   8d7e0c               | lea                 edi, [esi + 0xc]
            //   7c2c                 | jl                  0x2e
            //   8b10                 | mov                 edx, dword ptr [eax]

        $sequence_1 = { 33c0 5e 59 c3 51 8bc4 89642408 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   5e                   | pop                 esi
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   51                   | push                ecx
            //   8bc4                 | mov                 eax, esp
            //   89642408             | mov                 dword ptr [esp + 8], esp

        $sequence_2 = { 756c 8b4614 ba0c000000 f7e2 85d2 0f8719010000 7209 }
            // n = 7, score = 100
            //   756c                 | jne                 0x6e
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   ba0c000000           | mov                 edx, 0xc
            //   f7e2                 | mul                 edx
            //   85d2                 | test                edx, edx
            //   0f8719010000         | ja                  0x11f
            //   7209                 | jb                  0xb

        $sequence_3 = { 0f8412010000 83feff 7549 85db }
            // n = 4, score = 100
            //   0f8412010000         | je                  0x118
            //   83feff               | cmp                 esi, -1
            //   7549                 | jne                 0x4b
            //   85db                 | test                ebx, ebx

        $sequence_4 = { 8d7c2418 e8???????? c684243402000000 8b44241c 83c0f0 83c40c 8d480c }
            // n = 7, score = 100
            //   8d7c2418             | lea                 edi, [esp + 0x18]
            //   e8????????           |                     
            //   c684243402000000     | mov                 byte ptr [esp + 0x234], 0
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   83c0f0               | add                 eax, -0x10
            //   83c40c               | add                 esp, 0xc
            //   8d480c               | lea                 ecx, [eax + 0xc]

        $sequence_5 = { 8d4c2440 89442464 e8???????? 85c0 0f8462050000 }
            // n = 5, score = 100
            //   8d4c2440             | lea                 ecx, [esp + 0x40]
            //   89442464             | mov                 dword ptr [esp + 0x64], eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8462050000         | je                  0x568

        $sequence_6 = { e8???????? 83c410 837d2400 0f84c3000000 2b7508 d1fe }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   837d2400             | cmp                 dword ptr [ebp + 0x24], 0
            //   0f84c3000000         | je                  0xc9
            //   2b7508               | sub                 esi, dword ptr [ebp + 8]
            //   d1fe                 | sar                 esi, 1

        $sequence_7 = { 50 8b4204 ffd0 8b4c2418 8b41f4 3bc3 0f841e0e0000 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   ffd0                 | call                eax
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   8b41f4               | mov                 eax, dword ptr [ecx - 0xc]
            //   3bc3                 | cmp                 eax, ebx
            //   0f841e0e0000         | je                  0xe24

        $sequence_8 = { b9???????? 1bc0 f7d8 83c003 8bf0 a1???????? 8b500c }
            // n = 7, score = 100
            //   b9????????           |                     
            //   1bc0                 | sbb                 eax, eax
            //   f7d8                 | neg                 eax
            //   83c003               | add                 eax, 3
            //   8bf0                 | mov                 esi, eax
            //   a1????????           |                     
            //   8b500c               | mov                 edx, dword ptr [eax + 0xc]

        $sequence_9 = { 33c4 50 8d442420 64a300000000 33db 895c241c 895c2418 }
            // n = 7, score = 100
            //   33c4                 | xor                 eax, esp
            //   50                   | push                eax
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   33db                 | xor                 ebx, ebx
            //   895c241c             | mov                 dword ptr [esp + 0x1c], ebx
            //   895c2418             | mov                 dword ptr [esp + 0x18], ebx

    condition:
        7 of them and filesize < 196608
}