rule win_http_troy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.http_troy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.http_troy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 56 57 89842434010000 33c0 c644242800 b940000000 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   89842434010000       | mov                 dword ptr [esp + 0x134], eax
            //   33c0                 | xor                 eax, eax
            //   c644242800           | mov                 byte ptr [esp + 0x28], 0
            //   b940000000           | mov                 ecx, 0x40

        $sequence_1 = { f6c405 7a17 83f901 7508 dd05???????? eb02 d9ee }
            // n = 7, score = 200
            //   f6c405               | test                ah, 5
            //   7a17                 | jp                  0x19
            //   83f901               | cmp                 ecx, 1
            //   7508                 | jne                 0xa
            //   dd05????????         |                     
            //   eb02                 | jmp                 4
            //   d9ee                 | fldz                

        $sequence_2 = { 8b18 56 8b750c 3bf7 0f84b9000000 807e0800 0f84af000000 }
            // n = 7, score = 200
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   56                   | push                esi
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   3bf7                 | cmp                 esi, edi
            //   0f84b9000000         | je                  0xbf
            //   807e0800             | cmp                 byte ptr [esi + 8], 0
            //   0f84af000000         | je                  0xb5

        $sequence_3 = { 75f6 8d842458010000 8d5001 8a08 40 3acb 75f9 }
            // n = 7, score = 200
            //   75f6                 | jne                 0xfffffff8
            //   8d842458010000       | lea                 eax, [esp + 0x158]
            //   8d5001               | lea                 edx, [eax + 1]
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   3acb                 | cmp                 cl, bl
            //   75f9                 | jne                 0xfffffffb

        $sequence_4 = { 03c2 894518 8b4514 85c0 c7457c00000000 894d70 0f8568010000 }
            // n = 7, score = 200
            //   03c2                 | add                 eax, edx
            //   894518               | mov                 dword ptr [ebp + 0x18], eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   85c0                 | test                eax, eax
            //   c7457c00000000       | mov                 dword ptr [ebp + 0x7c], 0
            //   894d70               | mov                 dword ptr [ebp + 0x70], ecx
            //   0f8568010000         | jne                 0x16e

        $sequence_5 = { f644244c01 66897c244e 7505 8064244cf7 668b4c244c 8b54247c 2b5510 }
            // n = 7, score = 200
            //   f644244c01           | test                byte ptr [esp + 0x4c], 1
            //   66897c244e           | mov                 word ptr [esp + 0x4e], di
            //   7505                 | jne                 7
            //   8064244cf7           | and                 byte ptr [esp + 0x4c], 0xf7
            //   668b4c244c           | mov                 cx, word ptr [esp + 0x4c]
            //   8b54247c             | mov                 edx, dword ptr [esp + 0x7c]
            //   2b5510               | sub                 edx, dword ptr [ebp + 0x10]

        $sequence_6 = { 85c0 740f 33c0 8b4c2414 e8???????? 83c418 c3 }
            // n = 7, score = 200
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   33c0                 | xor                 eax, eax
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   c3                   | ret                 

        $sequence_7 = { 8d45ac 50 8d8d6cffffff 51 68???????? 8b5508 52 }
            // n = 7, score = 200
            //   8d45ac               | lea                 eax, [ebp - 0x54]
            //   50                   | push                eax
            //   8d8d6cffffff         | lea                 ecx, [ebp - 0x94]
            //   51                   | push                ecx
            //   68????????           |                     
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   52                   | push                edx

        $sequence_8 = { 5d c3 56 ff15???????? 8b442414 50 ff15???????? }
            // n = 7, score = 200
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_9 = { 83e103 68???????? f3a4 e8???????? 83c404 8d942488000000 8d9b00000000 }
            // n = 7, score = 200
            //   83e103               | and                 ecx, 3
            //   68????????           |                     
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d942488000000       | lea                 edx, [esp + 0x88]
            //   8d9b00000000         | lea                 ebx, [ebx]

    condition:
        7 of them and filesize < 475136
}