rule win_ice_ix_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ice_ix."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ice_ix"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 897c2414 6a78 8d74243c 58 e8???????? 8b44240c 8b08 }
            // n = 7, score = 200
            //   897c2414             | mov                 dword ptr [esp + 0x14], edi
            //   6a78                 | push                0x78
            //   8d74243c             | lea                 esi, [esp + 0x3c]
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_1 = { 7564 6a62 8db550ffffff 58 }
            // n = 4, score = 200
            //   7564                 | jne                 0x66
            //   6a62                 | push                0x62
            //   8db550ffffff         | lea                 esi, [ebp - 0xb0]
            //   58                   | pop                 eax

        $sequence_2 = { 8d75dc b893000000 e8???????? 8d45fc }
            // n = 4, score = 200
            //   8d75dc               | lea                 esi, [ebp - 0x24]
            //   b893000000           | mov                 eax, 0x93
            //   e8????????           |                     
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_3 = { f645f404 7433 6a4a 8d75cc }
            // n = 4, score = 200
            //   f645f404             | test                byte ptr [ebp - 0xc], 4
            //   7433                 | je                  0x35
            //   6a4a                 | push                0x4a
            //   8d75cc               | lea                 esi, [ebp - 0x34]

        $sequence_4 = { 6a00 8d45f4 50 e8???????? 8db5d8feffff b89b000000 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8db5d8feffff         | lea                 esi, [ebp - 0x128]
            //   b89b000000           | mov                 eax, 0x9b

        $sequence_5 = { 6836084923 e8???????? 8945e8 85c0 7506 40 e9???????? }
            // n = 7, score = 200
            //   6836084923           | push                0x23490836
            //   e8????????           |                     
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   85c0                 | test                eax, eax
            //   7506                 | jne                 8
            //   40                   | inc                 eax
            //   e9????????           |                     

        $sequence_6 = { 56 ff5008 8b7df8 68cc000000 6a36 58 e8???????? }
            // n = 7, score = 200
            //   56                   | push                esi
            //   ff5008               | call                dword ptr [eax + 8]
            //   8b7df8               | mov                 edi, dword ptr [ebp - 8]
            //   68cc000000           | push                0xcc
            //   6a36                 | push                0x36
            //   58                   | pop                 eax
            //   e8????????           |                     

        $sequence_7 = { 7641 8d1438 8a0a 80f926 7505 }
            // n = 5, score = 200
            //   7641                 | jbe                 0x43
            //   8d1438               | lea                 edx, [eax + edi]
            //   8a0a                 | mov                 cl, byte ptr [edx]
            //   80f926               | cmp                 cl, 0x26
            //   7505                 | jne                 7

        $sequence_8 = { e8???????? 6a0a 8d7c2438 58 e8???????? 8b4508 8b00 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   6a0a                 | push                0xa
            //   8d7c2438             | lea                 edi, [esp + 0x38]
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_9 = { eb04 897c241c 6a77 8d742454 }
            // n = 4, score = 200
            //   eb04                 | jmp                 6
            //   897c241c             | mov                 dword ptr [esp + 0x1c], edi
            //   6a77                 | push                0x77
            //   8d742454             | lea                 esi, [esp + 0x54]

    condition:
        7 of them and filesize < 327680
}