rule win_icondown_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.icondown."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.icondown"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c7861401000001000000 e8???????? 8bf0 395e58 c74654df614300 7531 }
            // n = 6, score = 200
            //   c7861401000001000000     | mov    dword ptr [esi + 0x114], 1
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   395e58               | cmp                 dword ptr [esi + 0x58], ebx
            //   c74654df614300       | mov                 dword ptr [esi + 0x54], 0x4361df
            //   7531                 | jne                 0x33

        $sequence_1 = { b97f000000 33c0 8dbc246d010000 889c246c010000 f3ab 66ab aa }
            // n = 7, score = 200
            //   b97f000000           | mov                 ecx, 0x7f
            //   33c0                 | xor                 eax, eax
            //   8dbc246d010000       | lea                 edi, [esp + 0x16d]
            //   889c246c010000       | mov                 byte ptr [esp + 0x16c], bl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al

        $sequence_2 = { ff15???????? 8b442404 6a01 8b4c240c 83ec10 8bd4 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   6a01                 | push                1
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   83ec10               | sub                 esp, 0x10
            //   8bd4                 | mov                 edx, esp

        $sequence_3 = { 7403 8b4004 50 6a00 6803130000 51 ff15???????? }
            // n = 7, score = 200
            //   7403                 | je                  5
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6803130000           | push                0x1303
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_4 = { 3bd1 7f3f 8b542410 8a0a 8a5a01 3acb 7732 }
            // n = 7, score = 200
            //   3bd1                 | cmp                 edx, ecx
            //   7f3f                 | jg                  0x41
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   8a0a                 | mov                 cl, byte ptr [edx]
            //   8a5a01               | mov                 bl, byte ptr [edx + 1]
            //   3acb                 | cmp                 cl, bl
            //   7732                 | ja                  0x34

        $sequence_5 = { 68???????? ff15???????? 392d???????? 7e6f 8d04ad00000000 399c80641e4500 8d3480 }
            // n = 7, score = 200
            //   68????????           |                     
            //   ff15????????         |                     
            //   392d????????         |                     
            //   7e6f                 | jle                 0x71
            //   8d04ad00000000       | lea                 eax, [ebp*4]
            //   399c80641e4500       | cmp                 dword ptr [eax + eax*4 + 0x451e64], ebx
            //   8d3480               | lea                 esi, [eax + eax*4]

        $sequence_6 = { ff2485bc2f4000 56 8d44246c 55 50 e8???????? 83c40c }
            // n = 7, score = 200
            //   ff2485bc2f4000       | jmp                 dword ptr [eax*4 + 0x402fbc]
            //   56                   | push                esi
            //   8d44246c             | lea                 eax, [esp + 0x6c]
            //   55                   | push                ebp
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_7 = { 896c2420 896c2424 894c242c ff15???????? 8b5c2430 8b4c2428 }
            // n = 6, score = 200
            //   896c2420             | mov                 dword ptr [esp + 0x20], ebp
            //   896c2424             | mov                 dword ptr [esp + 0x24], ebp
            //   894c242c             | mov                 dword ptr [esp + 0x2c], ecx
            //   ff15????????         |                     
            //   8b5c2430             | mov                 ebx, dword ptr [esp + 0x30]
            //   8b4c2428             | mov                 ecx, dword ptr [esp + 0x28]

        $sequence_8 = { 50 ff74240c e8???????? c3 b8???????? c3 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   e8????????           |                     
            //   c3                   | ret                 
            //   b8????????           |                     
            //   c3                   | ret                 

        $sequence_9 = { 8a4e24 f6c101 7409 8b4e1c 85c9 7408 }
            // n = 6, score = 200
            //   8a4e24               | mov                 cl, byte ptr [esi + 0x24]
            //   f6c101               | test                cl, 1
            //   7409                 | je                  0xb
            //   8b4e1c               | mov                 ecx, dword ptr [esi + 0x1c]
            //   85c9                 | test                ecx, ecx
            //   7408                 | je                  0xa

    condition:
        7 of them and filesize < 5505024
}