rule win_industrial_spy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.industrial_spy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.industrial_spy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4881ec50020000 8b9c2480020000 498bf1 488bf9 448bcb }
            // n = 5, score = 100
            //   4881ec50020000       | lea                 ebx, [esp + 0x640]
            //   8b9c2480020000       | dec                 ecx
            //   498bf1               | mov                 ebx, dword ptr [ebx + 0x20]
            //   488bf9               | xor                 eax, eax
            //   448bcb               | mov                 dword ptr [ebp - 0x50], 0x68

        $sequence_1 = { 48896c2410 4889742418 57 4883ec20 8b742450 488d7904 89b790010000 }
            // n = 7, score = 100
            //   48896c2410           | dec                 ecx
            //   4889742418           | mov                 ebx, esp
            //   57                   | dec                 esp
            //   4883ec20             | arpl                ax, ax
            //   8b742450             | test                eax, eax
            //   488d7904             | xor                 edx, edx
            //   89b790010000         | dec                 eax

        $sequence_2 = { 8bc5 448bc3 2bc3 488d5718 4803d0 498bce e8???????? }
            // n = 7, score = 100
            //   8bc5                 | dec                 eax
            //   448bc3               | mov                 dword ptr [edi + 0x48], ebx
            //   2bc3                 | movsd               xmm0, qword ptr [eax]
            //   488d5718             | mov                 ebx, dword ptr [eax + 8]
            //   4803d0               | dec                 eax
            //   498bce               | lea                 eax, [0x102eb]
            //   e8????????           |                     

        $sequence_3 = { b80f000000 412bc1 41ffc1 8bd0 0fb64c05e7 0fb6441804 4403c0 }
            // n = 7, score = 100
            //   b80f000000           | or                  eax, eax
            //   412bc1               | add                 eax, dword ptr [ebp - 0x34]
            //   41ffc1               | add                 edx, eax
            //   8bd0                 | inc                 ecx
            //   0fb64c05e7           | mov                 eax, edx
            //   0fb6441804           | not                 eax
            //   4403c0               | rol                 edx, 0xa

        $sequence_4 = { 488d1576800000 e8???????? 8bcb 4885c0 740c }
            // n = 5, score = 100
            //   488d1576800000       | mov                 eax, dword ptr [eax + ebp*8]
            //   e8????????           |                     
            //   8bcb                 | inc                 edx
            //   4885c0               | cmp                 byte ptr [eax + edi*8 + 0x38], bl
            //   740c                 | jge                 0x839

        $sequence_5 = { e8???????? 85c0 7461 488d942468020000 488bcf e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   85c0                 | movzx               esi, bx
            //   7461                 | mov                 ecx, esi
            //   488d942468020000     | mov                 dword ptr [esp + 0x48], esi
            //   488bcf               | inc                 ecx
            //   e8????????           |                     

        $sequence_6 = { e8???????? 4885c0 754c 488d942428020000 488bcf e8???????? 4885c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4885c0               | mov                 esi, dword ptr [esp + 0x1a8]
            //   754c                 | dec                 eax
            //   488d942428020000     | mov                 ecx, eax
            //   488bcf               | dec                 ebp
            //   e8????????           |                     
            //   4885c0               | mov                 eax, ebp

        $sequence_7 = { 4885c0 7509 488d056f710100 eb04 4883c024 4883c428 c3 }
            // n = 7, score = 100
            //   4885c0               | inc                 ebp
            //   7509                 | xor                 eax, eax
            //   488d056f710100       | dec                 ecx
            //   eb04                 | mov                 edx, ebx
            //   4883c024             | dec                 esp
            //   4883c428             | lea                 eax, [0xfffec987]
            //   c3                   | dec                 ebx

        $sequence_8 = { 8b742450 488d7904 89b790010000 4c8d9780010000 410fb601 498be8 c1e018 }
            // n = 7, score = 100
            //   8b742450             | dec                 eax
            //   488d7904             | cmp                 ebx, eax
            //   89b790010000         | je                  0x19d
            //   4c8d9780010000       | cmp                 dword ptr [ebx + 0x190], 0
            //   410fb601             | mov                 edx, dword ptr [ebp + 0x40]
            //   498be8               | inc                 esp
            //   c1e018               | mov                 eax, dword ptr [ebp + 0x44]

        $sequence_9 = { 448bd2 418bc3 23c2 41f7d2 0bc8 034dc8 }
            // n = 6, score = 100
            //   448bd2               | dec                 eax
            //   418bc3               | cmp                 eax, edx
            //   23c2                 | jg                  0x3f3
            //   41f7d2               | dec                 edx
            //   0bc8                 | mov                 eax, dword ptr [eax + ebp*8]
            //   034dc8               | inc                 edx

    condition:
        7 of them and filesize < 339968
}