rule win_karma_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.karma."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.karma"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33f6 0fb74102 83c102 8bd0 6685c0 75da }
            // n = 6, score = 100
            //   33f6                 | xor                 esi, esi
            //   0fb74102             | movzx               eax, word ptr [ecx + 2]
            //   83c102               | add                 ecx, 2
            //   8bd0                 | mov                 edx, eax
            //   6685c0               | test                ax, ax
            //   75da                 | jne                 0xffffffdc

        $sequence_1 = { c745dc33000000 c745e032000000 c745e42d000000 c745e862000000 c745ec79000000 c745f074000000 }
            // n = 6, score = 100
            //   c745dc33000000       | mov                 dword ptr [ebp - 0x24], 0x33
            //   c745e032000000       | mov                 dword ptr [ebp - 0x20], 0x32
            //   c745e42d000000       | mov                 dword ptr [ebp - 0x1c], 0x2d
            //   c745e862000000       | mov                 dword ptr [ebp - 0x18], 0x62
            //   c745ec79000000       | mov                 dword ptr [ebp - 0x14], 0x79
            //   c745f074000000       | mov                 dword ptr [ebp - 0x10], 0x74

        $sequence_2 = { 0fb7040a 8d4902 668901 6685c0 75f1 8d8df4fdffff }
            // n = 6, score = 100
            //   0fb7040a             | movzx               eax, word ptr [edx + ecx]
            //   8d4902               | lea                 ecx, [ecx + 2]
            //   668901               | mov                 word ptr [ecx], ax
            //   6685c0               | test                ax, ax
            //   75f1                 | jne                 0xfffffff3
            //   8d8df4fdffff         | lea                 ecx, [ebp - 0x20c]

        $sequence_3 = { 8d55b8 50 8bca e8???????? 8d45b8 }
            // n = 5, score = 100
            //   8d55b8               | lea                 edx, [ebp - 0x48]
            //   50                   | push                eax
            //   8bca                 | mov                 ecx, edx
            //   e8????????           |                     
            //   8d45b8               | lea                 eax, [ebp - 0x48]

        $sequence_4 = { 85c0 750c 68???????? ffd6 a3???????? 8b15???????? 85d2 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   750c                 | jne                 0xe
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   a3????????           |                     
            //   8b15????????         |                     
            //   85d2                 | test                edx, edx

        $sequence_5 = { 8b4c2438 e8???????? 83c410 6a00 6a00 }
            // n = 5, score = 100
            //   8b4c2438             | mov                 ecx, dword ptr [esp + 0x38]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_6 = { 750d 83e820 8bc8 85c0 7fed 85c9 }
            // n = 6, score = 100
            //   750d                 | jne                 0xf
            //   83e820               | sub                 eax, 0x20
            //   8bc8                 | mov                 ecx, eax
            //   85c0                 | test                eax, eax
            //   7fed                 | jg                  0xffffffef
            //   85c9                 | test                ecx, ecx

        $sequence_7 = { 0f1f00 8d4341 c745fa3a005c00 668945f8 33c0 668945fe 8d45f8 }
            // n = 7, score = 100
            //   0f1f00               | nop                 dword ptr [eax]
            //   8d4341               | lea                 eax, [ebx + 0x41]
            //   c745fa3a005c00       | mov                 dword ptr [ebp - 6], 0x5c003a
            //   668945f8             | mov                 word ptr [ebp - 8], ax
            //   33c0                 | xor                 eax, eax
            //   668945fe             | mov                 word ptr [ebp - 2], ax
            //   8d45f8               | lea                 eax, [ebp - 8]

        $sequence_8 = { 750c 40 83f808 72f4 0f84b0000000 56 8bd6 }
            // n = 7, score = 100
            //   750c                 | jne                 0xe
            //   40                   | inc                 eax
            //   83f808               | cmp                 eax, 8
            //   72f4                 | jb                  0xfffffff6
            //   0f84b0000000         | je                  0xb6
            //   56                   | push                esi
            //   8bd6                 | mov                 edx, esi

        $sequence_9 = { 7f0c 8b442418 3bf8 0f8224ffffff 8b7c2410 ff742434 6a00 }
            // n = 7, score = 100
            //   7f0c                 | jg                  0xe
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   3bf8                 | cmp                 edi, eax
            //   0f8224ffffff         | jb                  0xffffff2a
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]
            //   ff742434             | push                dword ptr [esp + 0x34]
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 49208
}