rule win_keylogger_apt3_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.keylogger_apt3."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.keylogger_apt3"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? 8bd8 e8???????? 83c408 68???????? 68???????? }
            // n = 6, score = 300
            //   68????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   68????????           |                     
            //   68????????           |                     

        $sequence_1 = { ffd7 85c0 75ef 56 ffd7 8bf0 }
            // n = 6, score = 300
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   75ef                 | jne                 0xfffffff1
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   8bf0                 | mov                 esi, eax

        $sequence_2 = { 85f6 75ba 8b4c243c 5e }
            // n = 4, score = 300
            //   85f6                 | test                esi, esi
            //   75ba                 | jne                 0xffffffbc
            //   8b4c243c             | mov                 ecx, dword ptr [esp + 0x3c]
            //   5e                   | pop                 esi

        $sequence_3 = { 8d4c242c 68???????? 51 ffd7 a1???????? }
            // n = 5, score = 300
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   68????????           |                     
            //   51                   | push                ecx
            //   ffd7                 | call                edi
            //   a1????????           |                     

        $sequence_4 = { 8b5004 f7da 1ad2 22d1 }
            // n = 4, score = 300
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   f7da                 | neg                 edx
            //   1ad2                 | sbb                 dl, dl
            //   22d1                 | and                 dl, cl

        $sequence_5 = { 803b00 758d 8b44241c 40 81c614010000 3b442418 }
            // n = 6, score = 300
            //   803b00               | cmp                 byte ptr [ebx], 0
            //   758d                 | jne                 0xffffff8f
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]
            //   40                   | inc                 eax
            //   81c614010000         | add                 esi, 0x114
            //   3b442418             | cmp                 eax, dword ptr [esp + 0x18]

        $sequence_6 = { e8???????? 6a00 6a41 68???????? 8d4ddc }
            // n = 5, score = 300
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a41                 | push                0x41
            //   68????????           |                     
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]

        $sequence_7 = { 74c9 8b04cd74104300 5f 5e }
            // n = 4, score = 300
            //   74c9                 | je                  0xffffffcb
            //   8b04cd74104300       | mov                 eax, dword ptr [ecx*8 + 0x431074]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_8 = { 7daa 3b5c2420 7419 8b4c2424 51 }
            // n = 5, score = 300
            //   7daa                 | jge                 0xffffffac
            //   3b5c2420             | cmp                 ebx, dword ptr [esp + 0x20]
            //   7419                 | je                  0x1b
            //   8b4c2424             | mov                 ecx, dword ptr [esp + 0x24]
            //   51                   | push                ecx

        $sequence_9 = { 56 8b74240c 57 85f6 742f }
            // n = 5, score = 300
            //   56                   | push                esi
            //   8b74240c             | mov                 esi, dword ptr [esp + 0xc]
            //   57                   | push                edi
            //   85f6                 | test                esi, esi
            //   742f                 | je                  0x31

    condition:
        7 of them and filesize < 761856
}