rule win_keymarble_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.keymarble."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.keymarble"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 50 e8???????? 83c404 56 6a40 ff15???????? }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   56                   | push                esi
            //   6a40                 | push                0x40
            //   ff15????????         |                     

        $sequence_1 = { 83c408 85c0 7407 bb7a452301 }
            // n = 4, score = 200
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   bb7a452301           | mov                 ebx, 0x123457a

        $sequence_2 = { 50 ff15???????? 68???????? 6a40 }
            // n = 4, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   68????????           |                     
            //   6a40                 | push                0x40

        $sequence_3 = { e8???????? 83c404 e8???????? 8d3470 81e6ffffff7f }
            // n = 5, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   e8????????           |                     
            //   8d3470               | lea                 esi, [eax + esi*2]
            //   81e6ffffff7f         | and                 esi, 0x7fffffff

        $sequence_4 = { e8???????? 83c408 85c0 7407 bb7a452301 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   bb7a452301           | mov                 ebx, 0x123457a

        $sequence_5 = { e8???????? 83c404 56 6a40 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   56                   | push                esi
            //   6a40                 | push                0x40

        $sequence_6 = { ff15???????? 50 ff15???????? 68???????? 6a40 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   68????????           |                     
            //   6a40                 | push                0x40

        $sequence_7 = { e8???????? 83c404 56 6a40 ff15???????? }
            // n = 5, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   56                   | push                esi
            //   6a40                 | push                0x40
            //   ff15????????         |                     

        $sequence_8 = { 6a00 6a03 6800000040 57 ffd6 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   6a03                 | push                3
            //   6800000040           | push                0x40000000
            //   57                   | push                edi
            //   ffd6                 | call                esi

        $sequence_9 = { 56 e8???????? 68???????? ff15???????? 8bf0 85f6 }
            // n = 6, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

    condition:
        7 of them and filesize < 1146880
}