rule win_khrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.khrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.khrat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a3???????? 6a30 8d45d0 50 }
            // n = 4, score = 100
            //   a3????????           |                     
            //   6a30                 | push                0x30
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax

        $sequence_1 = { 8d1d10520010 8b4d08 6bc914 8d1c19 833b00 }
            // n = 5, score = 100
            //   8d1d10520010         | lea                 ebx, [0x10005210]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   6bc914               | imul                ecx, ecx, 0x14
            //   8d1c19               | lea                 ebx, [ecx + ebx]
            //   833b00               | cmp                 dword ptr [ebx], 0

        $sequence_2 = { 7517 8b4307 0fb74b02 83e90b 8d730b 51 56 }
            // n = 7, score = 100
            //   7517                 | jne                 0x19
            //   8b4307               | mov                 eax, dword ptr [ebx + 7]
            //   0fb74b02             | movzx               ecx, word ptr [ebx + 2]
            //   83e90b               | sub                 ecx, 0xb
            //   8d730b               | lea                 esi, [ebx + 0xb]
            //   51                   | push                ecx
            //   56                   | push                esi

        $sequence_3 = { 807b0500 757e 807b0600 7518 }
            // n = 4, score = 100
            //   807b0500             | cmp                 byte ptr [ebx + 5], 0
            //   757e                 | jne                 0x80
            //   807b0600             | cmp                 byte ptr [ebx + 6], 0
            //   7518                 | jne                 0x1a

        $sequence_4 = { 56 57 e8???????? 50 e8???????? 40 d1e0 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   40                   | inc                 eax
            //   d1e0                 | shl                 eax, 1

        $sequence_5 = { 8d85f8fcffff 50 8d85fcfdffff 50 6801000080 }
            // n = 5, score = 100
            //   8d85f8fcffff         | lea                 eax, [ebp - 0x308]
            //   50                   | push                eax
            //   8d85fcfdffff         | lea                 eax, [ebp - 0x204]
            //   50                   | push                eax
            //   6801000080           | push                0x80000001

        $sequence_6 = { 66c7464c0000 8db500fdffff 66c7067b00 66c746024600 66c746043800 66c746063800 66c746083500 }
            // n = 7, score = 100
            //   66c7464c0000         | mov                 word ptr [esi + 0x4c], 0
            //   8db500fdffff         | lea                 esi, [ebp - 0x300]
            //   66c7067b00           | mov                 word ptr [esi], 0x7b
            //   66c746024600         | mov                 word ptr [esi + 2], 0x46
            //   66c746043800         | mov                 word ptr [esi + 4], 0x38
            //   66c746063800         | mov                 word ptr [esi + 6], 0x38
            //   66c746083500         | mov                 word ptr [esi + 8], 0x35

        $sequence_7 = { ffb5bcfbffff 6a00 e8???????? c60300 c64301c4 }
            // n = 5, score = 100
            //   ffb5bcfbffff         | push                dword ptr [ebp - 0x444]
            //   6a00                 | push                0
            //   e8????????           |                     
            //   c60300               | mov                 byte ptr [ebx], 0
            //   c64301c4             | mov                 byte ptr [ebx + 1], 0xc4

        $sequence_8 = { 53 51 56 57 c785ecfdffff00000000 }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   56                   | push                esi
            //   57                   | push                edi
            //   c785ecfdffff00000000     | mov    dword ptr [ebp - 0x214], 0

        $sequence_9 = { 56 50 e8???????? eb0f 807b06ff 7509 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   eb0f                 | jmp                 0x11
            //   807b06ff             | cmp                 byte ptr [ebx + 6], 0xff
            //   7509                 | jne                 0xb

    condition:
        7 of them and filesize < 57344
}