rule win_kimsuky_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kimsuky."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kimsuky"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c418 8d85f8feffff 6a00 50 }
            // n = 4, score = 400
            //   83c418               | add                 esp, 0x18
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_1 = { 6a00 e8???????? 83c418 50 ff15???????? 8b4dfc }
            // n = 6, score = 400
            //   6a00                 | push                0
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_2 = { a1???????? 33c5 8945fc 833d????????00 7413 }
            // n = 5, score = 400
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   833d????????00       |                     
            //   7413                 | je                  0x15

        $sequence_3 = { 740a 33ff ff15???????? eb06 ff15???????? }
            // n = 5, score = 400
            //   740a                 | je                  0xc
            //   33ff                 | xor                 edi, edi
            //   ff15????????         |                     
            //   eb06                 | jmp                 8
            //   ff15????????         |                     

        $sequence_4 = { 6a00 8d85e8fdffff 50 8d85f0feffff 50 ff15???????? 85c0 }
            // n = 7, score = 400
            //   6a00                 | push                0
            //   8d85e8fdffff         | lea                 eax, [ebp - 0x218]
            //   50                   | push                eax
            //   8d85f0feffff         | lea                 eax, [ebp - 0x110]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_5 = { 75f9 2bca 51 8d85e4f5ffff 50 6a00 }
            // n = 6, score = 400
            //   75f9                 | jne                 0xfffffffb
            //   2bca                 | sub                 ecx, edx
            //   51                   | push                ecx
            //   8d85e4f5ffff         | lea                 eax, [ebp - 0xa1c]
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_6 = { ff15???????? 85c0 7516 ff15???????? 8bd8 e8???????? 0fafd8 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7516                 | jne                 0x18
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   e8????????           |                     
            //   0fafd8               | imul                ebx, eax

        $sequence_7 = { a3???????? 8d85dcf7ffff 50 53 ffd7 a3???????? }
            // n = 6, score = 400
            //   a3????????           |                     
            //   8d85dcf7ffff         | lea                 eax, [ebp - 0x824]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   ffd7                 | call                edi
            //   a3????????           |                     

        $sequence_8 = { 83c430 8d95f0fcffff b9???????? e8???????? 8d95ecfbffff b9???????? }
            // n = 6, score = 400
            //   83c430               | add                 esp, 0x30
            //   8d95f0fcffff         | lea                 edx, [ebp - 0x310]
            //   b9????????           |                     
            //   e8????????           |                     
            //   8d95ecfbffff         | lea                 edx, [ebp - 0x414]
            //   b9????????           |                     

        $sequence_9 = { 4889742438 4533ff 4c89642428 4c896c2420 33f6 }
            // n = 5, score = 300
            //   4889742438           | xor                 eax, eax
            //   4533ff               | dec                 ecx
            //   4c89642428           | mov                 ecx, esi
            //   4c896c2420           | inc                 ecx
            //   33f6                 | lea                 edx, [eax + 1]

        $sequence_10 = { ebdb 65488b042560000000 48897c2430 48896c2460 }
            // n = 4, score = 300
            //   ebdb                 | xor                 eax, eax
            //   65488b042560000000     | xor    edx, edx
            //   48897c2430           | dec                 eax
            //   48896c2460           | or                  ecx, 0xffffffff

        $sequence_11 = { 4533ed 4533e4 4c897c2468 e8???????? 488be8 b84d5a0000 0f1f440000 }
            // n = 7, score = 300
            //   4533ed               | dec                 ebp
            //   4533e4               | add                 ebx, ecx
            //   4c897c2468           | nop                 word ptr [eax + eax]
            //   e8????????           |                     
            //   488be8               | inc                 ecx
            //   b84d5a0000           | mov                 ecx, dword ptr [edx]
            //   0f1f440000           | jmp                 0xffffffdd

        $sequence_12 = { 33d2 4883c9ff 4903de ff542468 4533c0 498bce 418d5001 }
            // n = 7, score = 300
            //   33d2                 | xor                 edx, edx
            //   4883c9ff             | dec                 eax
            //   4903de               | or                  ecx, 0xffffffff
            //   ff542468             | dec                 ecx
            //   4533c0               | add                 ebx, esi
            //   498bce               | call                dword ptr [esp + 0x68]
            //   418d5001             | inc                 ebp

        $sequence_13 = { 468b540f20 468b5c0f24 4d03d1 4d03d9 666666660f1f840000000000 418b0a }
            // n = 6, score = 300
            //   468b540f20           | dec                 eax
            //   468b5c0f24           | mov                 ebp, dword ptr [esp + 0x60]
            //   4d03d1               | dec                 esp
            //   4d03d9               | arpl                word ptr [ebp + 0x3c], di
            //   666666660f1f840000000000     | xor    ecx, ecx
            //   418b0a               | inc                 ebp

        $sequence_14 = { 4533c0 498bce 418d5001 ffd3 488bc3 4883c440 415f }
            // n = 7, score = 300
            //   4533c0               | dec                 ecx
            //   498bce               | add                 ebx, esi
            //   418d5001             | call                dword ptr [esp + 0x68]
            //   ffd3                 | inc                 ebp
            //   488bc3               | xor                 eax, eax
            //   4883c440             | inc                 esi
            //   415f                 | mov                 edx, dword ptr [edi + ecx + 0x20]

        $sequence_15 = { 0f8540feffff 488b6c2460 4c637d3c 33c9 }
            // n = 4, score = 300
            //   0f8540feffff         | dec                 eax
            //   488b6c2460           | mov                 dword ptr [esp + 0x38], esi
            //   4c637d3c             | inc                 ebp
            //   33c9                 | xor                 edi, edi

        $sequence_16 = { 4c89642430 c744242880000000 c744242002000000 4533c9 4533c0 }
            // n = 5, score = 200
            //   4c89642430           | mov                 esi, dword ptr [ebp - 0x70]
            //   c744242880000000     | nop                 word ptr [eax + eax]
            //   c744242002000000     | cmp                 dword ptr [ebp - 0x10], 0
            //   4533c9               | mov                 ecx, edi
            //   4533c0               | test                eax, eax

        $sequence_17 = { 898521010000 66898525010000 888527010000 8b742450 }
            // n = 4, score = 200
            //   898521010000         | arpl                word ptr [ebp + 0x3c], di
            //   66898525010000       | xor                 ecx, ecx
            //   888527010000         | inc                 ecx
            //   8b742450             | mov                 eax, 0x3000

        $sequence_18 = { 8bbda0010000 8d4702 03c2 89442450 }
            // n = 4, score = 200
            //   8bbda0010000         | mov                 dword ptr [esp + 0x30], edi
            //   8d4702               | dec                 eax
            //   03c2                 | mov                 dword ptr [esp + 0x60], ebp
            //   89442450             | inc                 ebp

        $sequence_19 = { 894d90 8bc1 81fb00000001 0f97c0 }
            // n = 4, score = 200
            //   894d90               | inc                 ebp
            //   8bc1                 | xor                 esp, esp
            //   81fb00000001         | dec                 esp
            //   0f97c0               | mov                 dword ptr [esp + 0x68], edi

        $sequence_20 = { 83f809 8d7340 7405 be20000000 c68424a000000000 33d2 }
            // n = 6, score = 200
            //   83f809               | add                 edx, ecx
            //   8d7340               | dec                 ebp
            //   7405                 | add                 ebx, ecx
            //   be20000000           | nop                 word ptr [eax + eax]
            //   c68424a000000000     | inc                 ecx
            //   33d2                 | mov                 ecx, dword ptr [edx]

        $sequence_21 = { 8bd7 3bd8 0f94c2 85d2 7419 }
            // n = 5, score = 200
            //   8bd7                 | mov                 ebx, eax
            //   3bd8                 | imul                ebx, eax
            //   0f94c2               | test                eax, eax
            //   85d2                 | jne                 0x18
            //   7419                 | mov                 ebx, eax

        $sequence_22 = { 488d8a38000000 e9???????? 488d8a28010000 e9???????? }
            // n = 4, score = 200
            //   488d8a38000000       | mov                 dword ptr [ebp + 0xa0], edi
            //   e9????????           |                     
            //   488d8a28010000       | mov                 edx, edi
            //   e9????????           |                     

        $sequence_23 = { 85c0 0f8432020000 8b7590 660f1f440000 }
            // n = 4, score = 200
            //   85c0                 | dec                 ecx
            //   0f8432020000         | mov                 ecx, esi
            //   8b7590               | inc                 ebp
            //   660f1f440000         | xor                 ebp, ebp

        $sequence_24 = { 85c0 0f94c1 85c9 0f8494020000 89bda0000000 897d30 33c0 }
            // n = 7, score = 200
            //   85c0                 | inc                 ebp
            //   0f94c1               | xor                 eax, eax
            //   85c9                 | inc                 esi
            //   0f8494020000         | mov                 edx, dword ptr [edi + ecx + 0x20]
            //   89bda0000000         | inc                 esi
            //   897d30               | mov                 ebx, dword ptr [edi + ecx + 0x24]
            //   33c0                 | dec                 ebp

        $sequence_25 = { 6690 6644396102 488d4902 75f5 }
            // n = 4, score = 100
            //   6690                 | mov                 dword ptr [esp + 0x28], esp
            //   6644396102           | dec                 esp
            //   488d4902             | mov                 dword ptr [esp + 0x20], ebp
            //   75f5                 | xor                 esi, esi

        $sequence_26 = { 66c1e908 880c02 ff07 448b0f }
            // n = 4, score = 100
            //   66c1e908             | dec                 eax
            //   880c02               | lea                 ecx, [esp + 0x50]
            //   ff07                 | nop                 
            //   448b0f               | dec                 ecx

        $sequence_27 = { 6690 8bd7 4d8d45f0 83ff10 }
            // n = 4, score = 100
            //   6690                 | dec                 eax
            //   8bd7                 | lea                 ecx, [edx + 0x128]
            //   4d8d45f0             | dec                 eax
            //   83ff10               | lea                 ecx, [edx + 0x38]

        $sequence_28 = { 6690 49ffc0 6642833c4000 75f5 488d95ac020000 }
            // n = 5, score = 100
            //   6690                 | mov                 ebx, eax
            //   49ffc0               | imul                ebx, eax
            //   6642833c4000         | mov                 ebx, eax
            //   75f5                 | imul                ebx, eax
            //   488d95ac020000       | jne                 0x18

        $sequence_29 = { 6690 6644396202 488d5202 75f5 }
            // n = 4, score = 100
            //   6690                 | mov                 eax, ebx
            //   6644396202           | dec                 eax
            //   488d5202             | add                 esp, 0x40
            //   75f5                 | dec                 ecx

        $sequence_30 = { 6690 49ffc0 6642392c42 75f6 }
            // n = 4, score = 100
            //   6690                 | mov                 ecx, edi
            //   49ffc0               | test                eax, eax
            //   6642392c42           | sete                cl
            //   75f6                 | test                ecx, ecx

    condition:
        7 of them and filesize < 1021952
}