rule win_kins_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kins."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kins"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c9 75f8 85c0 7503 33c0 40 56 }
            // n = 7, score = 5000
            //   85c9                 | test                ecx, ecx
            //   75f8                 | jne                 0xfffffffa
            //   85c0                 | test                eax, eax
            //   7503                 | jne                 5
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   56                   | push                esi

        $sequence_1 = { 8bce e8???????? 85c0 0f8566ffffff 8b45f4 8b4d10 c1e005 }
            // n = 7, score = 5000
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8566ffffff         | jne                 0xffffff6c
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   c1e005               | shl                 eax, 5

        $sequence_2 = { bf80000000 57 e8???????? 33c9 89460c 3bc1 7505 }
            // n = 7, score = 5000
            //   bf80000000           | mov                 edi, 0x80
            //   57                   | push                edi
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   3bc1                 | cmp                 eax, ecx
            //   7505                 | jne                 7

        $sequence_3 = { 33c9 3b4708 8d542448 0f95c1 89742450 89742418 }
            // n = 6, score = 5000
            //   33c9                 | xor                 ecx, ecx
            //   3b4708               | cmp                 eax, dword ptr [edi + 8]
            //   8d542448             | lea                 edx, [esp + 0x48]
            //   0f95c1               | setne               cl
            //   89742450             | mov                 dword ptr [esp + 0x50], esi
            //   89742418             | mov                 dword ptr [esp + 0x18], esi

        $sequence_4 = { 8d45f4 7503 8d45fc 33f6 }
            // n = 4, score = 5000
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   7503                 | jne                 5
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   33f6                 | xor                 esi, esi

        $sequence_5 = { 7ced 33c0 40 c20400 }
            // n = 4, score = 5000
            //   7ced                 | jl                  0xffffffef
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   c20400               | ret                 4

        $sequence_6 = { 83e37f c1e007 4e 0bc3 47 80e180 7526 }
            // n = 7, score = 5000
            //   83e37f               | and                 ebx, 0x7f
            //   c1e007               | shl                 eax, 7
            //   4e                   | dec                 esi
            //   0bc3                 | or                  eax, ebx
            //   47                   | inc                 edi
            //   80e180               | and                 cl, 0x80
            //   7526                 | jne                 0x28

        $sequence_7 = { 85db 0f8532010000 8b442420 8b08 49 81e1ffffff0f 8908 }
            // n = 7, score = 5000
            //   85db                 | test                ebx, ebx
            //   0f8532010000         | jne                 0x138
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   49                   | dec                 ecx
            //   81e1ffffff0f         | and                 ecx, 0xfffffff
            //   8908                 | mov                 dword ptr [eax], ecx

        $sequence_8 = { 7427 8b542418 8b450c e8???????? 84c0 7417 8b54241c }
            // n = 7, score = 5000
            //   7427                 | je                  0x29
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7417                 | je                  0x19
            //   8b54241c             | mov                 edx, dword ptr [esp + 0x1c]

        $sequence_9 = { e8???????? 8d742448 e8???????? 33ff 85ff }
            // n = 5, score = 5000
            //   e8????????           |                     
            //   8d742448             | lea                 esi, [esp + 0x48]
            //   e8????????           |                     
            //   33ff                 | xor                 edi, edi
            //   85ff                 | test                edi, edi

    condition:
        7 of them and filesize < 548864
}