rule win_koiloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.koiloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.koiloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 41 83f950 72ec 8d9510ffffff 8d8d90f4ffff e8???????? 8d8d90f4ffff }
            // n = 7, score = 400
            //   41                   | inc                 ecx
            //   83f950               | cmp                 ecx, 0x50
            //   72ec                 | jb                  0xffffffee
            //   8d9510ffffff         | lea                 edx, [ebp - 0xf0]
            //   8d8d90f4ffff         | lea                 ecx, [ebp - 0xb70]
            //   e8????????           |                     
            //   8d8d90f4ffff         | lea                 ecx, [ebp - 0xb70]

        $sequence_1 = { b9???????? e8???????? 83c410 8945f0 85c0 0f8484030000 8bd0 }
            // n = 7, score = 400
            //   b9????????           |                     
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   85c0                 | test                eax, eax
            //   0f8484030000         | je                  0x38a
            //   8bd0                 | mov                 edx, eax

        $sequence_2 = { 2bf0 8b45e8 03c1 8975e0 8945e8 8bc8 }
            // n = 6, score = 400
            //   2bf0                 | sub                 esi, eax
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   03c1                 | add                 eax, ecx
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8bc8                 | mov                 ecx, eax

        $sequence_3 = { 83f844 72f5 8b45ec 8945c0 8945c4 33c0 c7458444000000 }
            // n = 7, score = 400
            //   83f844               | cmp                 eax, 0x44
            //   72f5                 | jb                  0xfffffff7
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   33c0                 | xor                 eax, eax
            //   c7458444000000       | mov                 dword ptr [ebp - 0x7c], 0x44

        $sequence_4 = { 8b5d08 53 6a00 ff15???????? 50 ff15???????? }
            // n = 6, score = 400
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_5 = { e8???????? 83c404 8d8d30f2ffff e8???????? 8d8d30f2ffff e8???????? }
            // n = 6, score = 400
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d8d30f2ffff         | lea                 ecx, [ebp - 0xdd0]
            //   e8????????           |                     
            //   8d8d30f2ffff         | lea                 ecx, [ebp - 0xdd0]
            //   e8????????           |                     

        $sequence_6 = { 8b45c4 c645fb00 8b3d???????? a801 7403 56 ffd7 }
            // n = 7, score = 400
            //   8b45c4               | mov                 eax, dword ptr [ebp - 0x3c]
            //   c645fb00             | mov                 byte ptr [ebp - 5], 0
            //   8b3d????????         |                     
            //   a801                 | test                al, 1
            //   7403                 | je                  5
            //   56                   | push                esi
            //   ffd7                 | call                edi

        $sequence_7 = { 8b4104 03c2 894148 8b4df8 8b55f0 8b7da8 }
            // n = 6, score = 400
            //   8b4104               | mov                 eax, dword ptr [ecx + 4]
            //   03c2                 | add                 eax, edx
            //   894148               | mov                 dword ptr [ecx + 0x48], eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   8b7da8               | mov                 edi, dword ptr [ebp - 0x58]

        $sequence_8 = { 03cf 740b 3801 7407 40 803c0100 75f9 }
            // n = 7, score = 400
            //   03cf                 | add                 ecx, edi
            //   740b                 | je                  0xd
            //   3801                 | cmp                 byte ptr [ecx], al
            //   7407                 | je                  9
            //   40                   | inc                 eax
            //   803c0100             | cmp                 byte ptr [ecx + eax], 0
            //   75f9                 | jne                 0xfffffffb

        $sequence_9 = { 41 3bca 72ef 8d45f8 c745f800000000 50 8d043a }
            // n = 7, score = 400
            //   41                   | inc                 ecx
            //   3bca                 | cmp                 ecx, edx
            //   72ef                 | jb                  0xfffffff1
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   50                   | push                eax
            //   8d043a               | lea                 eax, [edx + edi]

    condition:
        7 of them and filesize < 101376
}