rule win_koobface_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.koobface."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.koobface"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8508ffffff 0fb68000294200 8919 891e }
            // n = 4, score = 100
            //   8b8508ffffff         | mov                 eax, dword ptr [ebp - 0xf8]
            //   0fb68000294200       | movzx               eax, byte ptr [eax + 0x422900]
            //   8919                 | mov                 dword ptr [ecx], ebx
            //   891e                 | mov                 dword ptr [esi], ebx

        $sequence_1 = { 33c0 eb1b 8d3400 8bc6 e8???????? 8965f0 8bc4 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   eb1b                 | jmp                 0x1d
            //   8d3400               | lea                 esi, [eax + eax]
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   8bc4                 | mov                 eax, esp

        $sequence_2 = { 8d8548a2ffff 50 8d8514fcffff 50 e8???????? 83c410 84c0 }
            // n = 7, score = 100
            //   8d8548a2ffff         | lea                 eax, [ebp - 0x5db8]
            //   50                   | push                eax
            //   8d8514fcffff         | lea                 eax, [ebp - 0x3ec]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   84c0                 | test                al, al

        $sequence_3 = { 85c0 0f85ae000000 8b45e4 8b08 53 68???????? 50 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f85ae000000         | jne                 0xb4
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   53                   | push                ebx
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_4 = { e8???????? 8d85dca9ffff 50 e8???????? c70424???????? 8d8570a2ffff }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8d85dca9ffff         | lea                 eax, [ebp - 0x5624]
            //   50                   | push                eax
            //   e8????????           |                     
            //   c70424????????       |                     
            //   8d8570a2ffff         | lea                 eax, [ebp - 0x5d90]

        $sequence_5 = { e8???????? 8b8dccfdffff 8d850cffffff 50 c745fc04000000 e8???????? 834dfcff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b8dccfdffff         | mov                 ecx, dword ptr [ebp - 0x234]
            //   8d850cffffff         | lea                 eax, [ebp - 0xf4]
            //   50                   | push                eax
            //   c745fc04000000       | mov                 dword ptr [ebp - 4], 4
            //   e8????????           |                     
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff

        $sequence_6 = { 8b45e4 8b08 53 68???????? 50 ff5114 8d45ec }
            // n = 7, score = 100
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   53                   | push                ebx
            //   68????????           |                     
            //   50                   | push                eax
            //   ff5114               | call                dword ptr [ecx + 0x14]
            //   8d45ec               | lea                 eax, [ebp - 0x14]

        $sequence_7 = { 8d1485a0534200 8b0a 83e61f c1e606 03ce 8a4124 02c0 }
            // n = 7, score = 100
            //   8d1485a0534200       | lea                 edx, [eax*4 + 0x4253a0]
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   03ce                 | add                 ecx, esi
            //   8a4124               | mov                 al, byte ptr [ecx + 0x24]
            //   02c0                 | add                 al, al

        $sequence_8 = { e8???????? 8b8dd0fdffff 8d850cffffff 50 c745fc17000000 e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b8dd0fdffff         | mov                 ecx, dword ptr [ebp - 0x230]
            //   8d850cffffff         | lea                 eax, [ebp - 0xf4]
            //   50                   | push                eax
            //   c745fc17000000       | mov                 dword ptr [ebp - 4], 0x17
            //   e8????????           |                     

        $sequence_9 = { 33cd fec0 5e e8???????? c9 c3 55 }
            // n = 7, score = 100
            //   33cd                 | xor                 ecx, ebp
            //   fec0                 | inc                 al
            //   5e                   | pop                 esi
            //   e8????????           |                     
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp

    condition:
        7 of them and filesize < 368640
}