rule win_kutaki_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.kutaki."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.kutaki"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4de8 51 56 ff503c 3bc7 7d0f 6a3c }
            // n = 7, score = 700
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   51                   | push                ecx
            //   56                   | push                esi
            //   ff503c               | call                dword ptr [eax + 0x3c]
            //   3bc7                 | cmp                 eax, edi
            //   7d0f                 | jge                 0x11
            //   6a3c                 | push                0x3c

        $sequence_1 = { 898598feffff 83bd98feffff00 7d26 68a0000000 68???????? 8b859cfeffff 50 }
            // n = 7, score = 700
            //   898598feffff         | mov                 dword ptr [ebp - 0x168], eax
            //   83bd98feffff00       | cmp                 dword ptr [ebp - 0x168], 0
            //   7d26                 | jge                 0x28
            //   68a0000000           | push                0xa0
            //   68????????           |                     
            //   8b859cfeffff         | mov                 eax, dword ptr [ebp - 0x164]
            //   50                   | push                eax

        $sequence_2 = { 8b4db8 51 ff15???????? 898540ffffff eb0a c78540ffffff00000000 8b55d8 }
            // n = 7, score = 700
            //   8b4db8               | mov                 ecx, dword ptr [ebp - 0x48]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   898540ffffff         | mov                 dword ptr [ebp - 0xc0], eax
            //   eb0a                 | jmp                 0xc
            //   c78540ffffff00000000     | mov    dword ptr [ebp - 0xc0], 0
            //   8b55d8               | mov                 edx, dword ptr [ebp - 0x28]

        $sequence_3 = { 8b8db8feffff 51 ff90a0000000 dbe2 8985b4feffff 83bdb4feffff00 }
            // n = 6, score = 700
            //   8b8db8feffff         | mov                 ecx, dword ptr [ebp - 0x148]
            //   51                   | push                ecx
            //   ff90a0000000         | call                dword ptr [eax + 0xa0]
            //   dbe2                 | fnclex              
            //   8985b4feffff         | mov                 dword ptr [ebp - 0x14c], eax
            //   83bdb4feffff00       | cmp                 dword ptr [ebp - 0x14c], 0

        $sequence_4 = { 8d953cffffff 52 6808200000 ff15???????? 898564feffff 8d8564feffff 50 }
            // n = 7, score = 700
            //   8d953cffffff         | lea                 edx, [ebp - 0xc4]
            //   52                   | push                edx
            //   6808200000           | push                0x2008
            //   ff15????????         |                     
            //   898564feffff         | mov                 dword ptr [ebp - 0x19c], eax
            //   8d8564feffff         | lea                 eax, [ebp - 0x19c]
            //   50                   | push                eax

        $sequence_5 = { 51 8d45d8 52 50 ff15???????? 50 e8???????? }
            // n = 7, score = 700
            //   51                   | push                ecx
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   52                   | push                edx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_6 = { 8b45c8 898558ffffff c745c800000000 8b9558ffffff 8d4dcc ff15???????? c745fc30000000 }
            // n = 7, score = 700
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   898558ffffff         | mov                 dword ptr [ebp - 0xa8], eax
            //   c745c800000000       | mov                 dword ptr [ebp - 0x38], 0
            //   8b9558ffffff         | mov                 edx, dword ptr [ebp - 0xa8]
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   ff15????????         |                     
            //   c745fc30000000       | mov                 dword ptr [ebp - 4], 0x30

        $sequence_7 = { 57 50 ff15???????? 8d55c4 8d45c8 52 50 }
            // n = 7, score = 700
            //   57                   | push                edi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d55c4               | lea                 edx, [ebp - 0x3c]
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_8 = { 8b95d0feffff 52 8b85ccfeffff 50 ff15???????? 89853cfeffff eb0a }
            // n = 7, score = 700
            //   8b95d0feffff         | mov                 edx, dword ptr [ebp - 0x130]
            //   52                   | push                edx
            //   8b85ccfeffff         | mov                 eax, dword ptr [ebp - 0x134]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   89853cfeffff         | mov                 dword ptr [ebp - 0x1c4], eax
            //   eb0a                 | jmp                 0xc

        $sequence_9 = { 8d9578ffffff 52 ff15???????? 83c420 50 8d8568ffffff }
            // n = 6, score = 700
            //   8d9578ffffff         | lea                 edx, [ebp - 0x88]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83c420               | add                 esp, 0x20
            //   50                   | push                eax
            //   8d8568ffffff         | lea                 eax, [ebp - 0x98]

    condition:
        7 of them and filesize < 1335296
}