rule win_latentbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.latentbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.latentbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 6aff ff36 895dfc ffd0 85c0 7d13 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   6aff                 | push                -1
            //   ff36                 | push                dword ptr [esi]
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax
            //   7d13                 | jge                 0x15

        $sequence_1 = { c3 e8???????? 85c0 740c c7460802000000 e8???????? 33c0 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   740c                 | je                  0xe
            //   c7460802000000       | mov                 dword ptr [esi + 8], 2
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { ff742410 ff742410 e8???????? c20800 55 8bec 51 }
            // n = 7, score = 100
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   ff742410             | push                dword ptr [esp + 0x10]
            //   e8????????           |                     
            //   c20800               | ret                 8
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx

        $sequence_3 = { c3 55 8bec 83ec24 b874657874 8945e4 8945dc }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec24               | sub                 esp, 0x24
            //   b874657874           | mov                 eax, 0x74786574
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax

        $sequence_4 = { 59 59 33c0 c3 55 8bec 83ec38 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec38               | sub                 esp, 0x38

        $sequence_5 = { 83c418 eb02 33ff 57 6aff ff542418 5f }
            // n = 7, score = 100
            //   83c418               | add                 esp, 0x18
            //   eb02                 | jmp                 4
            //   33ff                 | xor                 edi, edi
            //   57                   | push                edi
            //   6aff                 | push                -1
            //   ff542418             | call                dword ptr [esp + 0x18]
            //   5f                   | pop                 edi

        $sequence_6 = { 53 55 56 57 8b790c 8b770c }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   55                   | push                ebp
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b790c               | mov                 edi, dword ptr [ecx + 0xc]
            //   8b770c               | mov                 esi, dword ptr [edi + 0xc]

        $sequence_7 = { 8945dc 64a118000000 8b4030 53 8b5808 8b433c }
            // n = 6, score = 100
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   64a118000000         | mov                 eax, dword ptr fs:[0x18]
            //   8b4030               | mov                 eax, dword ptr [eax + 0x30]
            //   53                   | push                ebx
            //   8b5808               | mov                 ebx, dword ptr [eax + 8]
            //   8b433c               | mov                 eax, dword ptr [ebx + 0x3c]

        $sequence_8 = { ffd0 4c 8b542468 45 33c9 45 33c0 }
            // n = 7, score = 100
            //   ffd0                 | call                eax
            //   4c                   | dec                 esp
            //   8b542468             | mov                 edx, dword ptr [esp + 0x68]
            //   45                   | inc                 ebp
            //   33c9                 | xor                 ecx, ecx
            //   45                   | inc                 ebp
            //   33c0                 | xor                 eax, eax

        $sequence_9 = { 57 53 894da8 ffd6 8bf0 83fe01 7569 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   53                   | push                ebx
            //   894da8               | mov                 dword ptr [ebp - 0x58], ecx
            //   ffd6                 | call                esi
            //   8bf0                 | mov                 esi, eax
            //   83fe01               | cmp                 esi, 1
            //   7569                 | jne                 0x6b

    condition:
        7 of them and filesize < 401408
}