rule win_lightlesscan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lightlesscan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lightlesscan"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b542450 488bce e8???????? eb11 83fb04 0f8571070000 }
            // n = 6, score = 100
            //   488b542450           | dec                 eax
            //   488bce               | cvtpi2ps            xmm2, mm1
            //   e8????????           |                     
            //   eb11                 | cvtdq2ps            xmm0, xmm0
            //   83fb04               | movdqa              xmmword ptr [esp + 0x20], xmm0
            //   0f8571070000         | dec                 eax

        $sequence_1 = { 8905???????? 741b 488d0d0e750300 e8???????? 488b0d???????? ffd0 8b05???????? }
            // n = 7, score = 100
            //   8905????????         |                     
            //   741b                 | mov                 esi, dword ptr [esp + 0x7c8]
            //   488d0d0e750300       | dec                 eax
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   ffd0                 | mov                 ebx, dword ptr [esp + 0x810]
            //   8b05????????         |                     

        $sequence_2 = { 4c8bca 488905???????? 66c7000a01 e8???????? 488d0d0a180400 c705????????01000000 e8???????? }
            // n = 7, score = 100
            //   4c8bca               | dec                 eax
            //   488905????????       |                     
            //   66c7000a01           | mov                 ecx, dword ptr [esp + 0x48]
            //   e8????????           |                     
            //   488d0d0a180400       | dec                 esp
            //   c705????????01000000     |     
            //   e8????????           |                     

        $sequence_3 = { 48896c2418 56 57 4154 4881ec80020000 488b05???????? }
            // n = 6, score = 100
            //   48896c2418           | dec                 esp
            //   56                   | lea                 eax, [ecx - 1]
            //   57                   | dec                 eax
            //   4154                 | mov                 ecx, edi
            //   4881ec80020000       | dec                 eax
            //   488b05????????       |                     

        $sequence_4 = { 4c8d41ff 498bcc e8???????? 4c8d0580d30400 488d15f1cb0400 488d8d00020000 e8???????? }
            // n = 7, score = 100
            //   4c8d41ff             | lea                 ebp, [esp - 0xf50]
            //   498bcc               | push                ebp
            //   e8????????           |                     
            //   4c8d0580d30400       | push                edi
            //   488d15f1cb0400       | inc                 ecx
            //   488d8d00020000       | push                esp
            //   e8????????           |                     

        $sequence_5 = { 48899c24e0040000 488b5c2448 4c89bc2490040000 4883c308 4c8d3d63780500 8b03 83f8ff }
            // n = 7, score = 100
            //   48899c24e0040000     | lea                 ecx, [0x36278]
            //   488b5c2448           | dec                 eax
            //   4c89bc2490040000     | arpl                ax, bx
            //   4883c308             | dec                 eax
            //   4c8d3d63780500       | mov                 edx, ebx
            //   8b03                 | mov                 ecx, 0x40
            //   83f8ff               | dec                 eax

        $sequence_6 = { 4d2bc8 ba08020000 48ffc9 49d1f9 894d80 488d8df0030000 4d03c9 }
            // n = 7, score = 100
            //   4d2bc8               | inc                 esp
            //   ba08020000           | movzx               eax, word ptr [ecx + 2]
            //   48ffc9               | dec                 eax
            //   49d1f9               | add                 ecx, 2
            //   894d80               | inc                 bp
            //   488d8df0030000       | test                eax, eax
            //   4d03c9               | je                  0x98d

        $sequence_7 = { 66f2af 48f7d1 4c8d41ff 498bcc e8???????? 488bcb ff15???????? }
            // n = 7, score = 100
            //   66f2af               | je                  0x13f
            //   48f7d1               | cmp                 dword ptr [eax], edi
            //   4c8d41ff             | jne                 0x13f
            //   498bcc               | cmp                 dword ptr [eax + 8], edi
            //   e8????????           |                     
            //   488bcb               | jne                 0x13f
            //   ff15????????         |                     

        $sequence_8 = { 4c8bc0 4883c702 4983c002 eb0f 664489a5a0070000 4c8b4650 498bf8 }
            // n = 7, score = 100
            //   4c8bc0               | mov                 ecx, dword ptr [esp + 0x50]
            //   4883c702             | dec                 esp
            //   4983c002             | lea                 ecx, [eax + eax + 2]
            //   eb0f                 | mov                 edx, 0x208
            //   664489a5a0070000     | dec                 eax
            //   4c8b4650             | lea                 ecx, [ebp + 0x260]
            //   498bf8               | inc                 ecx

        $sequence_9 = { 488b4c2468 488b01 ff5010 e9???????? 488b4c2458 488b01 4533c0 }
            // n = 7, score = 100
            //   488b4c2468           | lea                 edx, [0x4e46e]
            //   488b01               | dec                 eax
            //   ff5010               | lea                 edx, [0x59b02]
            //   e9????????           |                     
            //   488b4c2458           | dec                 eax
            //   488b01               | lea                 ecx, [esp + 0x70]
            //   4533c0               | dec                 eax

    condition:
        7 of them and filesize < 1399808
}