rule win_lilith_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lilith."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lilith"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4d08 898814434300 68???????? e8???????? 8be5 5d c3 }
            // n = 7, score = 200
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   898814434300         | mov                 dword ptr [eax + 0x434314], ecx
            //   68????????           |                     
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_1 = { 897df0 8b04bda84b4300 8955e8 8a4c0228 884dff f6c101 0f8425030000 }
            // n = 7, score = 200
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi
            //   8b04bda84b4300       | mov                 eax, dword ptr [edi*4 + 0x434ba8]
            //   8955e8               | mov                 dword ptr [ebp - 0x18], edx
            //   8a4c0228             | mov                 cl, byte ptr [edx + eax + 0x28]
            //   884dff               | mov                 byte ptr [ebp - 1], cl
            //   f6c101               | test                cl, 1
            //   0f8425030000         | je                  0x32b

        $sequence_2 = { 6bc830 8b0495a84b4300 f644082801 7421 }
            // n = 4, score = 200
            //   6bc830               | imul                ecx, eax, 0x30
            //   8b0495a84b4300       | mov                 eax, dword ptr [edx*4 + 0x434ba8]
            //   f644082801           | test                byte ptr [eax + ecx + 0x28], 1
            //   7421                 | je                  0x23

        $sequence_3 = { c78558ffffff0f000000 c78554ffffff00000000 c68544ffffff00 c745fc00000000 8b3d???????? 8b1d???????? 0f1f4000 }
            // n = 7, score = 200
            //   c78558ffffff0f000000     | mov    dword ptr [ebp - 0xa8], 0xf
            //   c78554ffffff00000000     | mov    dword ptr [ebp - 0xac], 0
            //   c68544ffffff00       | mov                 byte ptr [ebp - 0xbc], 0
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b3d????????         |                     
            //   8b1d????????         |                     
            //   0f1f4000             | nop                 dword ptr [eax]

        $sequence_4 = { c78560ffffff00000000 6a00 50 c7855cffffff00000000 e8???????? 83c40c }
            // n = 6, score = 200
            //   c78560ffffff00000000     | mov    dword ptr [ebp - 0xa0], 0
            //   6a00                 | push                0
            //   50                   | push                eax
            //   c7855cffffff00000000     | mov    dword ptr [ebp - 0xa4], 0
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_5 = { 83fe04 7cdc 5f 5e }
            // n = 4, score = 200
            //   83fe04               | cmp                 esi, 4
            //   7cdc                 | jl                  0xffffffde
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_6 = { ffb390210000 ff15???????? 83f8ff 740f 03f0 }
            // n = 5, score = 200
            //   ffb390210000         | push                dword ptr [ebx + 0x2190]
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   740f                 | je                  0x11
            //   03f0                 | add                 esi, eax

        $sequence_7 = { d3c8 3305???????? 3905???????? 0f85334a0000 ff7508 e8???????? }
            // n = 6, score = 200
            //   d3c8                 | ror                 eax, cl
            //   3305????????         |                     
            //   3905????????         |                     
            //   0f85334a0000         | jne                 0x4a39
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     

        $sequence_8 = { 53 8b5d10 8b0485a84b4300 56 }
            // n = 4, score = 200
            //   53                   | push                ebx
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   8b0485a84b4300       | mov                 eax, dword ptr [eax*4 + 0x434ba8]
            //   56                   | push                esi

        $sequence_9 = { 56 57 ff7520 8bf1 e8???????? }
            // n = 5, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   ff7520               | push                dword ptr [ebp + 0x20]
            //   8bf1                 | mov                 esi, ecx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 499712
}