rule win_linseningsvr_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.linseningsvr."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.linseningsvr"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d34b558874000 832600 83c60c 4a 75f7 8b00 8b35???????? }
            // n = 7, score = 100
            //   8d34b558874000       | lea                 esi, [esi*4 + 0x408758]
            //   832600               | and                 dword ptr [esi], 0
            //   83c60c               | add                 esi, 0xc
            //   4a                   | dec                 edx
            //   75f7                 | jne                 0xfffffff9
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b35????????         |                     

        $sequence_1 = { 47 3bfe 7ce7 68???????? e8???????? 8b15???????? b900010000 }
            // n = 7, score = 100
            //   47                   | inc                 edi
            //   3bfe                 | cmp                 edi, esi
            //   7ce7                 | jl                  0xffffffe9
            //   68????????           |                     
            //   e8????????           |                     
            //   8b15????????         |                     
            //   b900010000           | mov                 ecx, 0x100

        $sequence_2 = { 83f908 7229 f3a5 ff2495982c4000 8bc7 ba03000000 }
            // n = 6, score = 100
            //   83f908               | cmp                 ecx, 8
            //   7229                 | jb                  0x2b
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   ff2495982c4000       | jmp                 dword ptr [edx*4 + 0x402c98]
            //   8bc7                 | mov                 eax, edi
            //   ba03000000           | mov                 edx, 3

        $sequence_3 = { e8???????? b900010000 33c0 8dbc2450040000 55 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   b900010000           | mov                 ecx, 0x100
            //   33c0                 | xor                 eax, eax
            //   8dbc2450040000       | lea                 edi, [esp + 0x450]
            //   55                   | push                ebp

        $sequence_4 = { 8d3c8dc08d4000 c1e603 8b0f f644310401 7456 50 e8???????? }
            // n = 7, score = 100
            //   8d3c8dc08d4000       | lea                 edi, [ecx*4 + 0x408dc0]
            //   c1e603               | shl                 esi, 3
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   f644310401           | test                byte ptr [ecx + esi + 4], 1
            //   7456                 | je                  0x58
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 7c13 80fb78 7f0e 0fbec3 8a801c714000 }
            // n = 5, score = 100
            //   7c13                 | jl                  0x15
            //   80fb78               | cmp                 bl, 0x78
            //   7f0e                 | jg                  0x10
            //   0fbec3               | movsx               eax, bl
            //   8a801c714000         | mov                 al, byte ptr [eax + 0x40711c]

        $sequence_6 = { 52 56 66895c2448 6689442456 ff15???????? 8bd8 }
            // n = 6, score = 100
            //   52                   | push                edx
            //   56                   | push                esi
            //   66895c2448           | mov                 word ptr [esp + 0x48], bx
            //   6689442456           | mov                 word ptr [esp + 0x56], ax
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_7 = { 8944241c 33ff 8bc8 83f940 5d }
            // n = 5, score = 100
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   33ff                 | xor                 edi, edi
            //   8bc8                 | mov                 ecx, eax
            //   83f940               | cmp                 ecx, 0x40
            //   5d                   | pop                 ebp

        $sequence_8 = { 8088818c400008 40 3dff000000 72f1 56 }
            // n = 5, score = 100
            //   8088818c400008       | or                  byte ptr [eax + 0x408c81], 8
            //   40                   | inc                 eax
            //   3dff000000           | cmp                 eax, 0xff
            //   72f1                 | jb                  0xfffffff3
            //   56                   | push                esi

        $sequence_9 = { 8ac8 80c120 8888808b4000 eb1f 83f861 7213 83f87a }
            // n = 7, score = 100
            //   8ac8                 | mov                 cl, al
            //   80c120               | add                 cl, 0x20
            //   8888808b4000         | mov                 byte ptr [eax + 0x408b80], cl
            //   eb1f                 | jmp                 0x21
            //   83f861               | cmp                 eax, 0x61
            //   7213                 | jb                  0x15
            //   83f87a               | cmp                 eax, 0x7a

    condition:
        7 of them and filesize < 81360
}