rule win_lockbit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lockbit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lockbit"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 49 8bc1 5f 59 5d }
            // n = 5, score = 300
            //   49                   | dec                 ecx
            //   8bc1                 | mov                 eax, ecx
            //   5f                   | pop                 edi
            //   59                   | pop                 ecx
            //   5d                   | pop                 ebp

        $sequence_1 = { c20800 33c0 40 c1e006 }
            // n = 4, score = 300
            //   c20800               | ret                 8
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   c1e006               | shl                 eax, 6

        $sequence_2 = { 4f 85ff 75c1 5f }
            // n = 4, score = 300
            //   4f                   | dec                 edi
            //   85ff                 | test                edi, edi
            //   75c1                 | jne                 0xffffffc3
            //   5f                   | pop                 edi

        $sequence_3 = { 8d45f8 50 8d45fc 50 ff75fc ff75f4 }
            // n = 6, score = 300
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff75f4               | push                dword ptr [ebp - 0xc]

        $sequence_4 = { 03d0 90 85c0 75e1 8bc2 5e 5a }
            // n = 7, score = 300
            //   03d0                 | add                 edx, eax
            //   90                   | nop                 
            //   85c0                 | test                eax, eax
            //   75e1                 | jne                 0xffffffe3
            //   8bc2                 | mov                 eax, edx
            //   5e                   | pop                 esi
            //   5a                   | pop                 edx

        $sequence_5 = { 33c0 8d7df0 33c9 53 0fa2 8bf3 5b }
            // n = 7, score = 300
            //   33c0                 | xor                 eax, eax
            //   8d7df0               | lea                 edi, [ebp - 0x10]
            //   33c9                 | xor                 ecx, ecx
            //   53                   | push                ebx
            //   0fa2                 | cpuid               
            //   8bf3                 | mov                 esi, ebx
            //   5b                   | pop                 ebx

        $sequence_6 = { 8b7508 b961000000 66ad 90 6683f841 720b 6683f85a }
            // n = 7, score = 300
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   b961000000           | mov                 ecx, 0x61
            //   66ad                 | lodsw               ax, word ptr [esi]
            //   90                   | nop                 
            //   6683f841             | cmp                 ax, 0x41
            //   720b                 | jb                  0xd
            //   6683f85a             | cmp                 ax, 0x5a

        $sequence_7 = { 83ec10 53 56 57 33c0 8d7df0 33c9 }
            // n = 7, score = 300
            //   83ec10               | sub                 esp, 0x10
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33c0                 | xor                 eax, eax
            //   8d7df0               | lea                 edi, [ebp - 0x10]
            //   33c9                 | xor                 ecx, ecx

        $sequence_8 = { f745f800000002 740c 5f 5e b801000000 5b }
            // n = 6, score = 300
            //   f745f800000002       | test                dword ptr [ebp - 8], 0x2000000
            //   740c                 | je                  0xe
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx

        $sequence_9 = { 33d0 8bc1 c1e810 0fb6c0 c1e208 }
            // n = 5, score = 300
            //   33d0                 | xor                 edx, eax
            //   8bc1                 | mov                 eax, ecx
            //   c1e810               | shr                 eax, 0x10
            //   0fb6c0               | movzx               eax, al
            //   c1e208               | shl                 edx, 8

        $sequence_10 = { 720b 6683f85a 7705 6683c820 90 02f1 }
            // n = 6, score = 300
            //   720b                 | jb                  0xd
            //   6683f85a             | cmp                 ax, 0x5a
            //   7705                 | ja                  7
            //   6683c820             | or                  ax, 0x20
            //   90                   | nop                 
            //   02f1                 | add                 dh, cl

        $sequence_11 = { 2d04040404 49 75f4 8b7d0c be40000000 33db 55 }
            // n = 7, score = 300
            //   2d04040404           | sub                 eax, 0x4040404
            //   49                   | dec                 ecx
            //   75f4                 | jne                 0xfffffff6
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   be40000000           | mov                 esi, 0x40
            //   33db                 | xor                 ebx, ebx
            //   55                   | push                ebp

        $sequence_12 = { 8d8550fdffff 50 6a00 ff15???????? }
            // n = 4, score = 300
            //   8d8550fdffff         | lea                 eax, [ebp - 0x2b0]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_13 = { 8bf3 5b 8907 897704 894f08 89570c f745f800000002 }
            // n = 7, score = 300
            //   8bf3                 | mov                 esi, ebx
            //   5b                   | pop                 ebx
            //   8907                 | mov                 dword ptr [edi], eax
            //   897704               | mov                 dword ptr [edi + 4], esi
            //   894f08               | mov                 dword ptr [edi + 8], ecx
            //   89570c               | mov                 dword ptr [edi + 0xc], edx
            //   f745f800000002       | test                dword ptr [ebp - 8], 0x2000000

        $sequence_14 = { 8d45f4 50 6a00 6a00 ff15???????? }
            // n = 5, score = 300
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_15 = { e8???????? 85c0 7502 eb59 8d3c47 6a00 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   eb59                 | jmp                 0x5b
            //   8d3c47               | lea                 edi, [edi + eax*2]
            //   6a00                 | push                0

        $sequence_16 = { 0f28c8 660f73f904 660fefc8 0f28c1 660f73f804 660fefc1 }
            // n = 6, score = 300
            //   0f28c8               | movaps              xmm1, xmm0
            //   660f73f904           | pslldq              xmm1, 4
            //   660fefc8             | pxor                xmm1, xmm0
            //   0f28c1               | movaps              xmm0, xmm1
            //   660f73f804           | pslldq              xmm0, 4
            //   660fefc1             | pxor                xmm0, xmm1

        $sequence_17 = { 6a00 6a00 6800000040 ff75d4 }
            // n = 4, score = 300
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6800000040           | push                0x40000000
            //   ff75d4               | push                dword ptr [ebp - 0x2c]

        $sequence_18 = { 7413 83e910 660f6f0c0e 660f3a0fc10f 660f7f040f }
            // n = 5, score = 200
            //   7413                 | je                  0x15
            //   83e910               | sub                 ecx, 0x10
            //   660f6f0c0e           | movdqa              xmm1, xmmword ptr [esi + ecx]
            //   660f3a0fc10f         | palignr             xmm0, xmm1, 0xf
            //   660f7f040f           | movdqa              xmmword ptr [edi + ecx], xmm0

        $sequence_19 = { 234df0 094ddc 0155dc 8b55f4 8bf2 c1ce0b 8bca }
            // n = 7, score = 200
            //   234df0               | and                 ecx, dword ptr [ebp - 0x10]
            //   094ddc               | or                  dword ptr [ebp - 0x24], ecx
            //   0155dc               | add                 dword ptr [ebp - 0x24], edx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   8bf2                 | mov                 esi, edx
            //   c1ce0b               | ror                 esi, 0xb
            //   8bca                 | mov                 ecx, edx

    condition:
        7 of them and filesize < 2049024
}