rule win_logtu_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.logtu."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.logtu"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 e8???????? 8d85fcf7ffff 6800040000 }
            // n = 4, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85fcf7ffff         | lea                 eax, [ebp - 0x804]
            //   6800040000           | push                0x400

        $sequence_1 = { 6a64 6a00 ff15???????? 85c0 7509 8b45bc }
            // n = 6, score = 300
            //   6a64                 | push                0x64
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7509                 | jne                 0xb
            //   8b45bc               | mov                 eax, dword ptr [ebp - 0x44]

        $sequence_2 = { 8d8534ffffff 50 ff15???????? 6a01 8bf0 8d85a4fdffff 68???????? }
            // n = 7, score = 300
            //   8d8534ffffff         | lea                 eax, [ebp - 0xcc]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   8bf0                 | mov                 esi, eax
            //   8d85a4fdffff         | lea                 eax, [ebp - 0x25c]
            //   68????????           |                     

        $sequence_3 = { 50 8d8574faffff 50 8d8534ffffff }
            // n = 4, score = 300
            //   50                   | push                eax
            //   8d8574faffff         | lea                 eax, [ebp - 0x58c]
            //   50                   | push                eax
            //   8d8534ffffff         | lea                 eax, [ebp - 0xcc]

        $sequence_4 = { 6a01 8bf0 8d85a4fdffff 68???????? 50 ff15???????? }
            // n = 6, score = 300
            //   6a01                 | push                1
            //   8bf0                 | mov                 esi, eax
            //   8d85a4fdffff         | lea                 eax, [ebp - 0x25c]
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_5 = { 56 ff15???????? 56 ff15???????? 8b45f8 5e 8be5 }
            // n = 7, score = 300
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp

        $sequence_6 = { 50 8d8534ffffff 50 8d8514fcffff 50 }
            // n = 5, score = 300
            //   50                   | push                eax
            //   8d8534ffffff         | lea                 eax, [ebp - 0xcc]
            //   50                   | push                eax
            //   8d8514fcffff         | lea                 eax, [ebp - 0x3ec]
            //   50                   | push                eax

        $sequence_7 = { 50 e8???????? 8d85fcf7ffff 6800040000 50 }
            // n = 5, score = 300
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85fcf7ffff         | lea                 eax, [ebp - 0x804]
            //   6800040000           | push                0x400
            //   50                   | push                eax

        $sequence_8 = { ff15???????? 56 ff15???????? 8b45f8 5e 8be5 }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp

        $sequence_9 = { 50 ff15???????? 6a01 8bf0 8d85a4fdffff 68???????? 50 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   8bf0                 | mov                 esi, eax
            //   8d85a4fdffff         | lea                 eax, [ebp - 0x25c]
            //   68????????           |                     
            //   50                   | push                eax

    condition:
        7 of them and filesize < 924672
}