rule win_lyposit_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.lyposit."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.lyposit"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb0a c645e703 eb04 c645e702 8d7e01 897dd8 c645e300 }
            // n = 7, score = 200
            //   eb0a                 | jmp                 0xc
            //   c645e703             | mov                 byte ptr [ebp - 0x19], 3
            //   eb04                 | jmp                 6
            //   c645e702             | mov                 byte ptr [ebp - 0x19], 2
            //   8d7e01               | lea                 edi, [esi + 1]
            //   897dd8               | mov                 dword ptr [ebp - 0x28], edi
            //   c645e300             | mov                 byte ptr [ebp - 0x1d], 0

        $sequence_1 = { 8945e0 56 6a40 ffd7 8945e4 56 ff75e0 }
            // n = 7, score = 200
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   56                   | push                esi
            //   6a40                 | push                0x40
            //   ffd7                 | call                edi
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   56                   | push                esi
            //   ff75e0               | push                dword ptr [ebp - 0x20]

        $sequence_2 = { 59 895ddc 395de0 740f 8b45cc 3bc3 }
            // n = 6, score = 200
            //   59                   | pop                 ecx
            //   895ddc               | mov                 dword ptr [ebp - 0x24], ebx
            //   395de0               | cmp                 dword ptr [ebp - 0x20], ebx
            //   740f                 | je                  0x11
            //   8b45cc               | mov                 eax, dword ptr [ebp - 0x34]
            //   3bc3                 | cmp                 eax, ebx

        $sequence_3 = { 0f8d42040000 837e04ff 7408 e8???????? 8b450c }
            // n = 5, score = 200
            //   0f8d42040000         | jge                 0x448
            //   837e04ff             | cmp                 dword ptr [esi + 4], -1
            //   7408                 | je                  0xa
            //   e8????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_4 = { 83c410 834dfcff eb91 55 8bec 837d0c10 742c }
            // n = 7, score = 200
            //   83c410               | add                 esp, 0x10
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   eb91                 | jmp                 0xffffff93
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   837d0c10             | cmp                 dword ptr [ebp + 0xc], 0x10
            //   742c                 | je                  0x2e

        $sequence_5 = { 53 e8???????? 8bf8 53 e8???????? ff75d0 }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   53                   | push                ebx
            //   e8????????           |                     
            //   ff75d0               | push                dword ptr [ebp - 0x30]

        $sequence_6 = { c1e804 a801 743b 8b4d10 0fb701 6683f82f }
            // n = 6, score = 200
            //   c1e804               | shr                 eax, 4
            //   a801                 | test                al, 1
            //   743b                 | je                  0x3d
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   0fb701               | movzx               eax, word ptr [ecx]
            //   6683f82f             | cmp                 ax, 0x2f

        $sequence_7 = { be00040000 6a1e 8945f0 5f bbba000000 c745f440010000 }
            // n = 6, score = 200
            //   be00040000           | mov                 esi, 0x400
            //   6a1e                 | push                0x1e
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   5f                   | pop                 edi
            //   bbba000000           | mov                 ebx, 0xba
            //   c745f440010000       | mov                 dword ptr [ebp - 0xc], 0x140

        $sequence_8 = { 395d0c 750b 834dfcff 33c0 e9???????? 391d???????? }
            // n = 6, score = 200
            //   395d0c               | cmp                 dword ptr [ebp + 0xc], ebx
            //   750b                 | jne                 0xd
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   391d????????         |                     

        $sequence_9 = { 59 e8???????? e2f9 59 43 83e903 }
            // n = 6, score = 200
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   e2f9                 | loop                0xfffffffb
            //   59                   | pop                 ecx
            //   43                   | inc                 ebx
            //   83e903               | sub                 ecx, 3

    condition:
        7 of them and filesize < 466944
}