rule win_magic_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.magic_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.magic_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb1c 85c0 7910 ba00200000 29c2 89d0 c1f80e }
            // n = 7, score = 600
            //   eb1c                 | mov                 ecx, dword ptr [esp + 0x28]
            //   85c0                 | mov                 eax, dword ptr [ecx]
            //   7910                 | test                eax, eax
            //   ba00200000           | dec                 eax
            //   29c2                 | mov                 ecx, esi
            //   89d0                 | dec                 esp
            //   c1f80e               | mov                 edx, esp

        $sequence_1 = { 0f842f010000 83f8ff 740e f0832d????????01 }
            // n = 4, score = 600
            //   0f842f010000         | dec                 eax
            //   83f8ff               | mov                 ecx, dword ptr [edi + 8]
            //   740e                 | dec                 eax
            //   f0832d????????01     |                     

        $sequence_2 = { c1e010 eb1c 85c0 7910 ba00200000 29c2 89d0 }
            // n = 7, score = 600
            //   c1e010               | mov                 eax, dword ptr [ebp - 0x14c]
            //   eb1c                 | mov                 dword ptr [ebp - 0x84], eax
            //   85c0                 | mov                 ecx, dword ptr [ebp - 0x168]
            //   7910                 | mov                 edx, dword ptr [eax]
            //   ba00200000           | mov                 edi, dword ptr [ebp - 0x15c]
            //   29c2                 | mov                 dword ptr [esp], 0x1a
            //   89d0                 | mov                 eax, dword ptr [ebp - 0x14c]

        $sequence_3 = { 7442 81fa???????? 742a 81fa???????? 7442 81fa???????? 744a }
            // n = 7, score = 600
            //   7442                 | mov                 eax, dword ptr [ebx]
            //   81fa????????         |                     
            //   742a                 | test                eax, eax
            //   81fa????????         |                     
            //   7442                 | js                  0x673
            //   81fa????????         |                     
            //   744a                 | push                esi

        $sequence_4 = { f6c380 b801000000 750d 89d8 c1e806 83f001 83e001 }
            // n = 7, score = 600
            //   f6c380               | lea                 ecx, [ebp + 0x10]
            //   b801000000           | mov                 eax, dword ptr [ebp + 4]
            //   750d                 | mov                 ebp, dword ptr [ebp + 8]
            //   89d8                 | test                ebp, ebp
            //   c1e806               | je                  0xdf2
            //   83f001               | lea                 ecx, [ebp + 0x10]
            //   83e001               | mov                 eax, dword ptr [ebp + 4]

        $sequence_5 = { 66251ffc 0c80 66894348 e9???????? }
            // n = 4, score = 600
            //   66251ffc             | dec                 eax
            //   0c80                 | mov                 dword ptr [esp + 0x38], eax
            //   66894348             | dec                 eax
            //   e9????????           |                     

        $sequence_6 = { 85c0 7910 ba00200000 29c2 89d0 c1f80e }
            // n = 6, score = 600
            //   85c0                 | dec                 eax
            //   7910                 | lea                 ecx, [0x9bb832]
            //   ba00200000           | mov                 edx, 0xb
            //   29c2                 | dec                 eax
            //   89d0                 | mov                 dword ptr [ebx], eax
            //   c1f80e               | cmp                 edx, 0x50000

        $sequence_7 = { c0e902 83e101 09ca c1e202 }
            // n = 4, score = 600
            //   c0e902               | mov                 eax, dword ptr [ebp - 0x9c]
            //   83e101               | mov                 edi, dword ptr [ebp - 0x84]
            //   09ca                 | mov                 eax, dword ptr [ebp - 0x6c]
            //   c1e202               | je                  0x24d

        $sequence_8 = { 0fb754244c 69d2e8030000 01d0 0fb754244e }
            // n = 4, score = 600
            //   0fb754244c           | mov                 dword ptr [esp], edi
            //   69d2e8030000         | mov                 dword ptr [esp + 0x28], eax
            //   01d0                 | movzx               ecx, word ptr [edx]
            //   0fb754244e           | lea                 eax, [ecx - 9]

        $sequence_9 = { 660f28c8 f20f5c0d???????? f20f2cd1 660fefc9 f20f2aca f20f5cc1 }
            // n = 6, score = 600
            //   660f28c8             | mov                 ecx, 0x48
            //   f20f5c0d????????     |                     
            //   f20f2cd1             | dec                 eax
            //   660fefc9             | lea                 edi, [esp + 0x28]
            //   f20f2aca             | inc                 ecx
            //   f20f5cc1             | mov                 eax, 2

    condition:
        7 of them and filesize < 41843712
}