rule win_makloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.makloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.makloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945fc 837dfc0a 7332 8b4dfc 51 8b4df8 }
            // n = 6, score = 200
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc0a             | cmp                 dword ptr [ebp - 4], 0xa
            //   7332                 | jae                 0x34
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   51                   | push                ecx
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

        $sequence_1 = { 8b4dfc 034820 894de8 8b55f4 }
            // n = 4, score = 200
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   034820               | add                 ecx, dword ptr [eax + 0x20]
            //   894de8               | mov                 dword ptr [ebp - 0x18], ecx
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]

        $sequence_2 = { 8d8d6cfeffff 83c1ff 898d24e6ffff 8b9524e6ffff 8a4201 888561e6ffff 838524e6ffff01 }
            // n = 7, score = 200
            //   8d8d6cfeffff         | lea                 ecx, [ebp - 0x194]
            //   83c1ff               | add                 ecx, -1
            //   898d24e6ffff         | mov                 dword ptr [ebp - 0x19dc], ecx
            //   8b9524e6ffff         | mov                 edx, dword ptr [ebp - 0x19dc]
            //   8a4201               | mov                 al, byte ptr [edx + 1]
            //   888561e6ffff         | mov                 byte ptr [ebp - 0x199f], al
            //   838524e6ffff01       | add                 dword ptr [ebp - 0x19dc], 1

        $sequence_3 = { 52 8b4dfc e8???????? 8b4dfc 884135 ba01000000 6bc235 }
            // n = 7, score = 200
            //   52                   | push                edx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   884135               | mov                 byte ptr [ecx + 0x35], al
            //   ba01000000           | mov                 edx, 1
            //   6bc235               | imul                eax, edx, 0x35

        $sequence_4 = { e8???????? 83c404 ba01000000 6bca03 8b5508 0fbe0c0a 33c1 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   ba01000000           | mov                 edx, 1
            //   6bca03               | imul                ecx, edx, 3
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0fbe0c0a             | movsx               ecx, byte ptr [edx + ecx]
            //   33c1                 | xor                 eax, ecx

        $sequence_5 = { 8a956be6ffff 8811 8b85d4e5ffff 83c001 8985d4e5ffff 8b8d08e6ffff 83c101 }
            // n = 7, score = 200
            //   8a956be6ffff         | mov                 dl, byte ptr [ebp - 0x1995]
            //   8811                 | mov                 byte ptr [ecx], dl
            //   8b85d4e5ffff         | mov                 eax, dword ptr [ebp - 0x1a2c]
            //   83c001               | add                 eax, 1
            //   8985d4e5ffff         | mov                 dword ptr [ebp - 0x1a2c], eax
            //   8b8d08e6ffff         | mov                 ecx, dword ptr [ebp - 0x19f8]
            //   83c101               | add                 ecx, 1

        $sequence_6 = { 6bc21c 8b4d08 0fb61401 52 8b4dfc }
            // n = 5, score = 200
            //   6bc21c               | imul                eax, edx, 0x1c
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   0fb61401             | movzx               edx, byte ptr [ecx + eax]
            //   52                   | push                edx
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]

        $sequence_7 = { 6bd105 8b4c05bc 894c15bc 8b4405c0 894415c0 b908000000 }
            // n = 6, score = 200
            //   6bd105               | imul                edx, ecx, 5
            //   8b4c05bc             | mov                 ecx, dword ptr [ebp + eax - 0x44]
            //   894c15bc             | mov                 dword ptr [ebp + edx - 0x44], ecx
            //   8b4405c0             | mov                 eax, dword ptr [ebp + eax - 0x40]
            //   894415c0             | mov                 dword ptr [ebp + edx - 0x40], eax
            //   b908000000           | mov                 ecx, 8

        $sequence_8 = { c705????????f8504200 b001 c3 68???????? e8???????? c70424???????? }
            // n = 6, score = 200
            //   c705????????f8504200     |     
            //   b001                 | mov                 al, 1
            //   c3                   | ret                 
            //   68????????           |                     
            //   e8????????           |                     
            //   c70424????????       |                     

        $sequence_9 = { 8b4dfc 884114 ba01000000 6bc214 }
            // n = 4, score = 200
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   884114               | mov                 byte ptr [ecx + 0x14], al
            //   ba01000000           | mov                 edx, 1
            //   6bc214               | imul                eax, edx, 0x14

    condition:
        7 of them and filesize < 335872
}