rule win_makop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.makop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.makop"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d4c2414 51 a3???????? }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   51                   | push                ecx
            //   a3????????           |                     

        $sequence_1 = { ff15???????? 32c0 83c40c c3 837c240400 741f 8b0424 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   32c0                 | xor                 al, al
            //   83c40c               | add                 esp, 0xc
            //   c3                   | ret                 
            //   837c240400           | cmp                 dword ptr [esp + 4], 0
            //   741f                 | je                  0x21
            //   8b0424               | mov                 eax, dword ptr [esp]

        $sequence_2 = { 8d442414 50 51 6a00 6a00 57 }
            // n = 6, score = 100
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   57                   | push                edi

        $sequence_3 = { 7f06 0f84e6000000 f644241010 7432 }
            // n = 4, score = 100
            //   7f06                 | jg                  8
            //   0f84e6000000         | je                  0xec
            //   f644241010           | test                byte ptr [esp + 0x10], 0x10
            //   7432                 | je                  0x34

        $sequence_4 = { 85c0 5d 0f8596030000 8b0d???????? 50 68ef030000 51 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   5d                   | pop                 ebp
            //   0f8596030000         | jne                 0x39c
            //   8b0d????????         |                     
            //   50                   | push                eax
            //   68ef030000           | push                0x3ef
            //   51                   | push                ecx

        $sequence_5 = { 897d00 7e54 8bc6 8a08 }
            // n = 4, score = 100
            //   897d00               | mov                 dword ptr [ebp], edi
            //   7e54                 | jle                 0x56
            //   8bc6                 | mov                 eax, esi
            //   8a08                 | mov                 cl, byte ptr [eax]

        $sequence_6 = { 6a00 89542430 8b964c080000 55 89442430 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   89542430             | mov                 dword ptr [esp + 0x30], edx
            //   8b964c080000         | mov                 edx, dword ptr [esi + 0x84c]
            //   55                   | push                ebp
            //   89442430             | mov                 dword ptr [esp + 0x30], eax

        $sequence_7 = { 8bcb 51 8b8c244c010000 52 50 51 e8???????? }
            // n = 7, score = 100
            //   8bcb                 | mov                 ecx, ebx
            //   51                   | push                ecx
            //   8b8c244c010000       | mov                 ecx, dword ptr [esp + 0x14c]
            //   52                   | push                edx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_8 = { 0f8462010000 8b4d0c 8b7d08 8d442414 50 51 6a00 }
            // n = 7, score = 100
            //   0f8462010000         | je                  0x168
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   6a00                 | push                0

        $sequence_9 = { bf0d000000 be0a000000 668944241e 6689442430 6689442438 6689442446 }
            // n = 6, score = 100
            //   bf0d000000           | mov                 edi, 0xd
            //   be0a000000           | mov                 esi, 0xa
            //   668944241e           | mov                 word ptr [esp + 0x1e], ax
            //   6689442430           | mov                 word ptr [esp + 0x30], ax
            //   6689442438           | mov                 word ptr [esp + 0x38], ax
            //   6689442446           | mov                 word ptr [esp + 0x46], ax

    condition:
        7 of them and filesize < 107520
}